<?php
$page_title = "Pending Withdrawals";
require_once 'header.php'; // Includes security check and db connection

// Fetch all pending withdrawal transactions
$sql = "SELECT 
            t.id, t.amount, t.gateway, t.description, t.transaction_date,
            u.username 
        FROM transactions t
        JOIN users u ON t.user_id = u.id
        WHERE t.type = 'withdrawal' AND t.status = 'pending'
        ORDER BY t.transaction_date ASC";

$result = $conn->query($sql);
$pending_withdrawals = [];
if ($result) {
    while($row = $result->fetch_assoc()) {
        $pending_withdrawals[] = $row;
    }
}
$conn->close();
?>

<style>
    .data-table-container {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        margin-bottom: 20px;
        background: var(--card-bg);
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    
    .data-table {
        width: 100%;
        min-width: 600px;
        border-collapse: collapse;
    }
    
    .data-table th, .data-table td {
        padding: 12px 8px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .data-table th {
        background: #f9fafb;
        font-size: 12px;
        color: var(--secondary);
        text-transform: uppercase;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .data-table td {
        font-size: 14px;
    }
    
    .data-table tr:last-child td {
        border-bottom: none;
    }
    
    .action-buttons {
        display: flex;
        flex-wrap: wrap;
        gap: 6px;
    }
    
    .action-buttons button {
        padding: 6px 10px;
        border-radius: 6px;
        font-weight: 500;
        border: none;
        cursor: pointer;
        font-size: 13px;
        white-space: nowrap;
    }
    
    .approve-btn {
        color: #059669;
        background: #D1FAE5;
    }
    
    .decline-btn {
        color: #DC2626;
        background: #FEE2E2;
    }
    
    .feedback-msg {
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-weight: 500;
    }
    
    .feedback-msg.success {
        background: #D1FAE5;
        color: #065F46;
    }
    
    .amount-withdraw {
        color: #DC2626;
        font-weight: bold;
    }
    
    .no-data {
        text-align: center;
        padding: 30px;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .data-table th, .data-table td {
            padding: 10px 6px;
        }
        
        .action-buttons button {
            padding: 5px 8px;
            font-size: 12px;
        }
        
        .feedback-msg {
            padding: 12px;
            font-size: 14px;
        }
    }
    
    @media (max-width: 480px) {
        .data-table th, .data-table td {
            padding: 8px 4px;
            font-size: 13px;
        }
        
        .action-buttons {
            gap: 4px;
        }
        
        .action-buttons button {
            padding: 4px 6px;
            font-size: 11px;
        }
        
        .feedback-msg {
            padding: 10px;
            font-size: 13px;
        }
    }
</style>

<?php if (isset($_GET['status']) && $_GET['status'] == 'success'): ?>
    <div class="feedback-msg success">Action completed successfully!</div>
<?php endif; ?>

<div class="data-table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>User</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Details</th>
                <th>Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($pending_withdrawals)): ?>
                <tr>
                    <td colspan="6" class="no-data">No pending withdrawals found.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($pending_withdrawals as $withdrawal): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($withdrawal['username']); ?></td>
                        <td class="amount-withdraw">৳<?php echo htmlspecialchars(number_format(abs($withdrawal['amount']), 2)); ?></td>
                        <td><?php echo htmlspecialchars(ucfirst($withdrawal['gateway'])); ?></td>
                        <td><?php echo htmlspecialchars(ellipsis($withdrawal['description'], 15)); ?></td>
                        <td><?php echo date("d M, H:i", strtotime($withdrawal['transaction_date'])); ?></td>
                        <td>
                            <form method="POST" action="withdrawal_action.php" style="display:inline;">
                                <input type="hidden" name="id" value="<?php echo $withdrawal['id']; ?>">
                                <div class="action-buttons">
                                    <button type="submit" name="action" value="approve" class="approve-btn" onclick="return confirm('Confirm payment before approving.');">Approve</button>
                                    <button type="submit" name="action" value="decline" class="decline-btn" onclick="return confirm('Decline and refund?');">Decline</button>
                                </div>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php
// Helper function to truncate long text with ellipsis
function ellipsis($text, $max_length) {
    if (strlen($text) > $max_length) {
        return substr($text, 0, $max_length) . '...';
    }
    return $text;
}

require_once 'footer.php';
?>