<?php
$page_title = "Website Settings";
require_once 'header.php';

$success_message = '';
$error_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $settings_to_update = [
        'bkash_number'        => $_POST['bkash_number'] ?? '',
        'rocket_number'       => $_POST['rocket_number'] ?? '',
        'nagad_number'        => $_POST['nagad_number'] ?? '',
        'scrolling_notice'    => $_POST['scrolling_notice'] ?? '',
        'support_link'        => trim($_POST['support_link'] ?? ''),
        'min_withdraw_amount' => $_POST['min_withdraw_amount'] ?? '500',
        'min_deposit_amount'  => $_POST['min_deposit_amount'] ?? '100',
        'video_add_money'     => $_POST['video_add_money'] ?? '',
        'video_room_id'       => $_POST['video_room_id'] ?? '',
        'video_join_match'    => $_POST['video_join_match'] ?? ''
    ];

    try {
        $conn->begin_transaction();
        
        foreach ($settings_to_update as $key => $value) {
            $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) 
                                    ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
            if ($stmt === false) { throw new Exception("Prepare failed: " . $conn->error); }
            $stmt->bind_param("ss", $key, $value);
            if (!$stmt->execute()) { throw new Exception("Execute failed: " . $stmt->error); }
            $stmt->close();
        }
        
        $conn->commit();
        $success_message = "Settings updated successfully!";

    } catch (Exception $e) {
        $conn->rollback();
        error_log("Settings update error: " . $e->getMessage());
        $error_message = "An error occurred while saving settings.";
    }
}

$sql = "SELECT setting_key, setting_value FROM settings";
$result = $conn->query($sql);
$settings = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <style>
        .form-container { max-width: 800px; margin: auto; background: var(--card-bg); padding: 30px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        h3 { font-size: 18px; color: #111827; margin-top: 0; padding-bottom: 10px; border-bottom: 1px solid #e5e7eb; }
        .form-group { display: flex; flex-direction: column; margin-bottom: 20px; }
        .form-group label { font-weight: 500; margin-bottom: 8px; color: #374151; }
        .form-group input, .form-group textarea { padding: 10px 12px; border: 1px solid #D1D5DB; border-radius: 8px; font-size: 14px; width: 100%; box-sizing: border-box; font-family: 'Inter', sans-serif; }
        .form-group textarea { min-height: 80px; resize: vertical; }
        .form-actions { margin-top: 25px; display: flex; justify-content: flex-end; }
        .btn-submit { background: var(--primary); color: white; padding: 12px 25px; border: none; border-radius: 8px; font-weight: 600; font-size: 16px; cursor: pointer; transition: background-color 0.2s; }
        .btn-submit:hover { background: var(--primary-hover); }
        .success-msg { color: #065F46; background: #D1FAE5; padding: 12px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; }
        .error-msg { color: #991B1B; background: #FEE2E2; padding: 12px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; }
        hr { border: none; border-top: 1px solid #e5e7eb; margin: 30px 0; }
    </style>
</head>
<body>
<div class="form-container">
    <?php if(!empty($success_message)): ?>
        <div class="success-msg"><?php echo htmlspecialchars($success_message); ?></div>
    <?php endif; ?>
    <?php if(!empty($error_message)): ?>
        <div class="error-msg"><?php echo htmlspecialchars($error_message); ?></div>
    <?php endif; ?>

    <form method="POST" action="settings.php">
        <h3>General Settings</h3>
        <div class="form-group">
            <label for="scrolling_notice">Homepage Scrolling Notice</label>
            <textarea id="scrolling_notice" name="scrolling_notice"><?php echo htmlspecialchars($settings['scrolling_notice'] ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label for="support_link">Support Link</label>
            <input type="text" id="support_link" name="support_link" value="<?php echo htmlspecialchars($settings['support_link'] ?? ''); ?>" placeholder="e.g., https://t.me/your_username">
        </div>

        <hr>

        <h3>Payment Numbers</h3>
        <div class="form-group">
            <label for="bkash_number">bKash Number</label>
            <input type="text" id="bkash_number" name="bkash_number" value="<?php echo htmlspecialchars($settings['bkash_number'] ?? ''); ?>">
        </div>
         <div class="form-group">
            <label for="rocket_number">Rocket Number</label>
            <input type="text" id="rocket_number" name="rocket_number" value="<?php echo htmlspecialchars($settings['rocket_number'] ?? ''); ?>">
        </div>
         <div class="form-group">
            <label for="nagad_number">Nagad Number</label>
            <input type="text" id="nagad_number" name="nagad_number" value="<?php echo htmlspecialchars($settings['nagad_number'] ?? ''); ?>">
        </div>
        
        <hr>
        
        <h3>Video Help Links</h3>
        <div class="form-group">
            <label for="video_add_money">"How to Add Money" Video URL</label>
            <input type="text" id="video_add_money" name="video_add_money" value="<?php echo htmlspecialchars($settings['video_add_money'] ?? ''); ?>" placeholder="https://youtube.com/your-video-link">
        </div>
        <div class="form-group">
            <label for="video_room_id">"How to Collect Room ID" Video URL</label>
            <input type="text" id="video_room_id" name="video_room_id" value="<?php echo htmlspecialchars($settings['video_room_id'] ?? ''); ?>" placeholder="https://youtube.com/your-video-link">
        </div>
        <div class="form-group">
            <label for="video_join_match">"How to Join Match" Video URL</label>
            <input type="text" id="video_join_match" name="video_join_match" value="<?php echo htmlspecialchars($settings['video_join_match'] ?? ''); ?>" placeholder="https://youtube.com/your-video-link">
        </div>

        <hr>

        <h3>Financial Settings</h3>
        <div class="form-group">
            <label for="min_deposit_amount">Minimum Deposit Amount (Tk)</label>
            <input type="number" id="min_deposit_amount" name="min_deposit_amount" value="<?php echo htmlspecialchars($settings['min_deposit_amount'] ?? '100'); ?>">
        </div>
        <div class="form-group">
            <label for="min_withdraw_amount">Minimum Withdrawal Amount (Tk)</label>
            <input type="number" id="min_withdraw_amount" name="min_withdraw_amount" value="<?php echo htmlspecialchars($settings['min_withdraw_amount'] ?? '500'); ?>">
        </div>

        <div class="form-actions">
            <button type="submit" class="btn-submit">Save Settings</button>
        </div>
    </form>
</div>
</body>
</html>
<?php require_once 'footer.php'; ?>