<?php
// Define the page title before including the header
$page_title = "Manage Sliders";
require_once 'header.php'; // Includes security check, DB connection, and header HTML

// --- ACTION HANDLER ---
// This block processes 'add' or 'delete' actions.

// Handle ADDING a new slider
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_slider'])) {
    $image_url = trim($_POST['image_url']);
    $link_url = trim($_POST['link_url']);

    if (!empty($image_url)) {
        $sql = "INSERT INTO sliders (image_url, link_url) VALUES (?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $image_url, $link_url);
        $stmt->execute();
        // Redirect with a success message
        echo '<script>window.location.href = "sliders.php";</script>';
    }
}

// Handle DELETING a slider
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $slider_id = (int)$_GET['id'];
    $sql = "DELETE FROM sliders WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $slider_id);
    $stmt->execute();
    // Redirect with a success message
    echo '<script>window.location.href = "sliders.php";</script>';
}

// --- DATA FETCHING ---
// Fetch all existing sliders to display in the table
$sliders = $conn->query("SELECT id, image_url, link_url FROM sliders ORDER BY id DESC");

?>
<style>
    /* Mobile-first approach */
    .form-container { 
        max-width: 100%; 
        margin: 15px auto; 
        background: var(--card-bg); 
        padding: 20px; 
        border-radius: 12px; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.05); 
    }
    
    .form-group { 
        display: flex; 
        flex-direction: column; 
        margin-bottom: 15px; 
    }
    
    .form-group label { 
        font-weight: 500; 
        margin-bottom: 8px; 
        color: #374151; 
        font-size: 16px;
    }
    
    .form-group input { 
        padding: 12px; 
        border: 1px solid #D1D5DB; 
        border-radius: 8px; 
        font-size: 16px; 
        width: 100%; 
        box-sizing: border-box; 
    }
    
    .form-actions { 
        margin-top: 20px; 
        display: flex; 
        justify-content: flex-end; 
    }
    
    .btn-submit { 
        background: var(--primary); 
        color: white; 
        padding: 14px 25px; 
        border: none; 
        border-radius: 8px; 
        font-weight: 600; 
        font-size: 16px; 
        cursor: pointer; 
        width: 100%;
    }
    
    .success-msg { 
        color: #065F46; 
        background: #D1FAE5; 
        padding: 12px; 
        border-radius: 8px; 
        margin-bottom: 20px; 
        font-weight: 500; 
        font-size: 14px;
    }

    /* Table styles */
    .table-container { 
        margin-top: 30px; 
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    table { 
        width: 100%; 
        min-width: 600px; /* Minimum width for table */
        border-collapse: collapse; 
    }
    
    th, td { 
        padding: 12px 10px; 
        border: 1px solid #e5e7eb; 
        text-align: left; 
        vertical-align: middle; 
        font-size: 14px;
    }
    
    th { 
        background-color: #f9fafb; 
        font-weight: 600; 
    }
    
    .slider-preview { 
        max-width: 100px; 
        height: auto;
        border-radius: 6px; 
    }
    
    .action-btn.delete { 
        background-color: #EF4444; 
        color: white; 
        padding: 10px 15px; 
        text-decoration: none; 
        border-radius: 6px; 
        display: inline-block;
        text-align: center;
        font-size: 14px;
    }
    
    /* Responsive adjustments for tablets and desktops */
    @media (min-width: 768px) {
        .form-container {
            max-width: 800px;
            padding: 30px;
        }
        
        .btn-submit {
            width: auto;
        }
        
        .slider-preview {
            max-width: 200px;
        }
    }
</style>

<!-- Add New Slider Form -->
<div class="form-container">
    <h2>Add New Slider</h2>

    <?php if(isset($_GET['message'])): ?>
        <div class="success-msg">
            <?php 
                if ($_GET['message'] == 'added') echo 'Slider added successfully!';
                if ($_GET['message'] == 'deleted') echo 'Slider deleted successfully!';
            ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="sliders.php">
        <div class="form-group">
            <label for="image_url">Image URL</label>
            <input type="text" id="image_url" name="image_url" placeholder="https://example.com/slider.jpg" required>
        </div>
        <div class="form-group">
            <label for="link_url">Link URL (when clicked)</label>
            <input type="text" id="link_url" name="link_url" placeholder="Optional: https://your-link.com">
        </div>
        <div class="form-actions">
            <button type="submit" name="add_slider" class="btn-submit">Add Slider</button>
        </div>
    </form>
</div>

<!-- Existing Sliders Table -->
<div class="form-container table-container">
    <h2>Existing Sliders</h2>
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Preview</th>
                    <th>Image URL</th>
                    <th>Link URL</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($sliders->num_rows > 0): ?>
                    <?php while($slider = $sliders->fetch_assoc()): ?>
                        <tr>
                            <td><img src="<?php echo htmlspecialchars($slider['image_url']); ?>" alt="Slider Preview" class="slider-preview" loading="lazy"></td>
                            <td><?php echo htmlspecialchars($slider['image_url']); ?></td>
                            <td><?php echo htmlspecialchars($slider['link_url']); ?></td>
                            <td>
                                <a href="sliders.php?action=delete&id=<?php echo $slider['id']; ?>" class="action-btn delete" onclick="return confirm('Are you sure you want to delete this slider?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="text-align:center;">No sliders have been added yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
require_once 'footer.php';
?>