<?php
// This file handles the permanent deletion of a user.
require_once 'header.php'; // For session security check

// Only proceed if the form was submitted via POST and an ID is present
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
    $user_id_to_delete = (int)$_POST['id'];

    if ($user_id_to_delete > 0) {
        // We use a transaction because we might want to delete related data
        // from other tables (like registrations) in the future.
        // For now, CASCADE will handle it, but this is good practice.
        $conn->begin_transaction();
        try {
            // The DELETE query
            $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
            $stmt->bind_param("i", $user_id_to_delete);
            $stmt->execute();
            
            // If we get here, it was successful. Commit the changes.
            $conn->commit();
            
        } catch (Exception $e) {
            // If anything went wrong, roll back.
            $conn->rollback();
            // Optional: log the error -> error_log($e->getMessage());
        }
    }
}

// Redirect back to the user list regardless of success or failure
echo '<script>window.location.href = "user_delete.php";</script>';
?>