<?php
/*
 * Withdrawal Action Handler
 * /admin/withdrawal_action.php
 */
session_start();

// Security Check
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id'], $_POST['action'])) {
    
    require_once '../db_connect.php';
    
    $transaction_id = (int)$_POST['id'];
    $action = $_POST['action'];

    // Use a transaction for this critical operation
    $conn->begin_transaction();

    try {
        // Get the transaction details and lock the row
        $sql = "SELECT user_id, amount FROM transactions WHERE id = ? AND status = 'pending' AND type = 'withdrawal' FOR UPDATE";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $transaction_id);
        $stmt->execute();
        $transaction = $stmt->get_result()->fetch_assoc();

        if ($transaction) {
            if ($action === 'approve') {
                // If approved, the money is considered sent. Just update the transaction status.
                // The user's balance was already deducted on request.
                $update_txn_sql = "UPDATE transactions SET status = 'completed' WHERE id = ?";
                $stmt = $conn->prepare($update_txn_sql);
                $stmt->bind_param("i", $transaction_id);
                $stmt->execute();

            } elseif ($action === 'decline') {
                // If declined, we must REFUND the money to the user's balance.
                // The transaction amount is negative, so we subtract it (which adds it back).
                $refund_amount = $transaction['amount'];
                $update_balance_sql = "UPDATE users SET balance = balance - ? WHERE id = ?";
                $stmt = $conn->prepare($update_balance_sql);
                $stmt->bind_param("di", $refund_amount, $transaction['user_id']);
                $stmt->execute();

                // Then, update the transaction status to 'canceled' or 'failed'
                $update_txn_sql = "UPDATE transactions SET status = 'canceled' WHERE id = ?";
                $stmt = $conn->prepare($update_txn_sql);
                $stmt->bind_param("i", $transaction_id);
                $stmt->execute();
            }
            
            // If all steps succeeded, commit the changes
            $conn->commit();
            header("Location: withdrawals.php?status=success");
            exit();

        } else {
            throw new Exception("Transaction not found or already processed.");
        }
    } catch (Exception $e) {
        // If any part fails, roll back everything
        $conn->rollback();
        die("An error occurred: " . $e->getMessage() . " The transaction has been canceled. Please go back and try again.");
    }

    $stmt->close();
    $conn->close();

} else {
    header("Location: withdrawals.php");
    exit();
}
?>