<?php


session_start();
require_once 'db_connect.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$match_id = filter_input(INPUT_GET, 'match_id', FILTER_VALIDATE_INT);
if (!$match_id) {
    header("Location: results.php");
    exit();
}


$match_sql = "SELECT title FROM tournaments WHERE id = ?";
$stmt = $conn->prepare($match_sql);
$stmt->bind_param("i", $match_id);
$stmt->execute();
$match = $stmt->get_result()->fetch_assoc();

if (!$match) {
    die("Match not found.");
}


$winners_sql = "SELECT rank, in_game_name, kills, prize_awarded FROM match_winners WHERE tournament_id = ? ORDER BY rank ASC";
$stmt = $conn->prepare($winners_sql);
$stmt->bind_param("i", $match_id);
$stmt->execute();
$winners_result = $stmt->get_result();

$winners = [];
while ($row = $winners_result->fetch_assoc()) {
    $winners[] = $row;
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Full Result</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: Arial, sans-serif; background: #f2f3f5; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding-bottom: 20px; }
        .header { background: #2980b9; color: white; padding: 20px 15px; }
        .header a { color: white; text-decoration: none; font-size: 16px; display: inline-block; margin-bottom: 10px; }
        .header h2 { margin: 0; font-size: 22px; }
        
        .winner-table { width: 100%; border-collapse: collapse; margin-top: 15px; background: white; }
        .winner-table th, .winner-table td { padding: 12px 15px; text-align: left; border-bottom: 1px solid #e0e0e0; }
        .winner-table th { background: #f8f8f8; font-size: 12px; color: #555; text-transform: uppercase; }
        .winner-table td { font-size: 14px; }
        .winner-table tr:last-child td { border-bottom: none; }
        .winner-table .rank { font-weight: bold; text-align: center; font-size: 16px; }
        .winner-table .prize { color: #27ae60; font-weight: bold; }
        
        .rank-1 .rank { color: #d4af37; } 
        .rank-2 .rank { color: #c0c0c0; } 
        .rank-3 .rank { color: #cd7f32; } 

        .no-data { text-align:center; margin-top:80px; color:#7f8c8d; font-size: 18px; }
    </style>
</head>
<body>
    <div class="header">
        <a href="results.php">← Back to Results</a>
        <h2><?php echo htmlspecialchars($match['title']); ?></h2>
    </div>

    <div class="container">
        <?php if (empty($winners)): ?>
            <p class="no-data">Full results for this match have not been published yet.</p>
        <?php else: ?>
            <table class="winner-table">
                <thead>
                    <tr>
                        <th style="width: 50px; text-align:center;">#</th>
                        <th>Player</th>
                        <th style="width: 60px; text-align:center;">Kills</th>
                        <th style="width: 80px;">Prize</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($winners as $winner): ?>
                        <tr class="rank-<?php echo $winner['rank']; ?>">
                            <td class="rank"><?php echo htmlspecialchars($winner['rank']); ?></td>
                            <td><?php echo htmlspecialchars($winner['in_game_name']); ?></td>
                            <td style="text-align:center;"><?php echo htmlspecialchars($winner['kills']); ?></td>
                            <td class="prize">Tk<?php echo htmlspecialchars(number_format($winner['prize_awarded'], 2)); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</body>
</html>