<?php


session_start();
require_once 'db_connect.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];



$sql = "SELECT 
            t.id, t.title, t.match_time, t.status, t.category, t.image_url,
            rd.room_id, rd.room_pass
        FROM registrations r
        JOIN tournaments t ON r.tournament_id = t.id
        LEFT JOIN room_details rd ON t.id = rd.tournament_id
        WHERE r.user_id = ?
        ORDER BY 
            CASE t.status
                WHEN 'upcoming' THEN 1
                WHEN 'ongoing' THEN 2
                WHEN 'completed' THEN 3
                WHEN 'canceled' THEN 4
            END, 
            t.match_time DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$my_matches = [];
while ($row = $result->fetch_assoc()) {
    $my_matches[] = $row;
}
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title> My Matches</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --primary-color: #2980b9;
            --background-color: #f0f2f5;
            --card-background: #ffffff;
            --text-color: #333;
            --subtle-text: #666;
            --success-color: #27ae60;
            --error-color: #e74c3c;
            --ongoing-color: #f39c12;
            --canceled-color: #95a5a6;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            margin: 0;
            padding-bottom: 80px;
            background-color: var(--background-color);
        }
        .page-header {
            background: var(--card-background);
            padding: 15px;
            text-align: center;
            font-size: 18px;
            font-weight: 600;
            color: var(--text-color);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            position: sticky;
            top: 0;
            z-index: 10;
        }
        .match-card {
            background: var(--card-background);
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            margin: 15px;
            overflow: hidden; 
        }
        .card-main {
            padding: 15px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .card-main img {
            width: 55px;
            height: 55px;
            object-fit: cover;
            border-radius: 8px;
        }
        .match-info { flex: 1; }
        .match-info h3 {
            margin: 0 0 4px;
            font-size: 16px;
            color: var(--text-color);
        }
        .match-info p {
            margin: 0;
            font-size: 13px;
            color: var(--subtle-text);
        }
        .status-label {
            font-weight: bold;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 11px;
            color: white;
            text-transform: uppercase;
        }
        .status-completed { background: var(--success-color); }
        .status-upcoming { background: var(--ongoing-color); }
        .status-canceled { background: var(--canceled-color); }
        
        .room-details {
            background-color: #f8f9fa;
            border-top: 1px solid #e9ecef;
            padding: 15px;
            font-size: 14px;
        }
        .room-details p {
            margin: 0;
            text-align: center;
            color: var(--subtle-text);
        }
        .room-details .creds {
            display: flex;
            justify-content: space-around;
            text-align: center;
            margin-top: 10px;
        }
        .room-details .creds span {
            display: block;
            font-size: 12px;
            color: var(--subtle-text);
            margin-bottom: 4px;
        }
        .room-details .creds strong {
            font-size: 16px;
            color: var(--primary-color);
            background: #e9ecef;
            padding: 5px 15px;
            border-radius: 6px;
        }

        .no-data {
            margin: 80px auto;
            text-align: center;
            font-size: 16px;
            color: var(--subtle-text);
        }
        .no-data img {
            width: 120px;
            opacity: 0.5;
            margin-bottom: 15px;
        }
        .bottom-nav { 
            position: fixed; bottom: 0; left: 0; right: 0;
            background: white; border-top: 1px solid #ccc;
            display: flex; justify-content: space-around;
            padding: 8px 0; z-index: 999;
        }
        .bottom-nav a { text-align: center; font-size: 11px; color: #555; text-decoration: none; display: flex; flex-direction: column; align-items: center; }
        .bottom-nav a.active { color: var(--primary-color); font-weight: 600; }
        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }
    </style>
</head>
<body>

<div class="page-header">My Matches</div>

<?php if (empty($my_matches)): ?>
    <div class="no-data">
        <img src="images/empty.png" alt="Empty">
        <p>You haven't joined any matches yet.</p>
    </div>
<?php else: ?>
    <?php foreach ($my_matches as $match): ?>
        <div class="match-card">
            <div class="card-main">
                
                <img src="<?php echo htmlspecialchars($match['image_url'] ?? 'images/' . $match['category'] . '.jpg'); ?>" alt="Game">
                <div class="match-info">
                    <h3><?php echo htmlspecialchars($match['title']); ?></h3>
                    <p>Time: <?php echo date("d M Y, h:i A", strtotime($match['match_time'])); ?></p>
                </div>
                
                <span class="status-label status-<?php echo htmlspecialchars($match['status']); ?>">
                    <?php echo htmlspecialchars($match['status']); ?>
                </span>
            </div>
            
            
            <?php if ($match['status'] === 'upcoming' || $match['status'] === 'ongoing'): ?>
                <div class="room-details">
                    <?php if (!empty($match['room_id'])): ?>
                        
                        <div class="creds">
                            <div>
                                <span>Room ID</span>
                                <strong><?php echo htmlspecialchars($match['room_id']); ?></strong>
                            </div>
                            <div>
                                <span>Password</span>
                                <strong><?php echo htmlspecialchars($match['room_pass']); ?></strong>
                            </div>
                        </div>
                    <?php else: ?>
                        
                        <p>Room details will be shared here 15 minutes before the match starts.</p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
<?php endif; ?>



<div class="bottom-nav">
    <a href="home.php"><img src="icons/play.png"><span>Play</span></a>
    
    <a href="my-matches.php" class="active"><img src="icons/match.png"><span>My Matches</span></a>
    <a href="results.php"><img src="icons/results.png"><span>Results</span></a>
    <a href="profile.php"><img src="icons/profile.png"><span>Profile</span></a>
</div>

</body>
</html>