<?php


session_start();
require_once 'session_check.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];


$sql = "SELECT 
            u.username,
            u.balance,
            u.avatar_url,
            (SELECT COUNT(*) FROM registrations WHERE user_id = u.id) as matches_played,
            (SELECT COUNT(*) FROM match_winners mw JOIN registrations r ON mw.tournament_id = r.tournament_id WHERE r.user_id = u.id AND mw.rank = 1 AND mw.in_game_name = r.player_ign_data) as total_wins
        FROM users u
        WHERE u.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user_stats = $result->fetch_assoc();

if (!$user_stats) {
    
    die("Error: Could not retrieve user data.");
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Profile</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@500;700&display=swap');
        body { margin: 0; font-family: 'Montserrat', sans-serif; background: #f7f9fc; color: #2c3e50; }
        .profile-header { background: linear-gradient(135deg, #8e44ad, #2980b9); color: white; padding: 30px 20px; text-align: center; border-bottom-left-radius: 30px; border-bottom-right-radius: 30px; position: relative; }
        .profile-header img { width: 100px; height: 100px; border-radius: 50%; border: 5px solid white; background: #fff; object-fit: cover; margin-bottom: 10px; }
        .profile-header h2 { margin: 0; font-size: 24px; font-weight: 700; }
        .profile-stats { display: flex; justify-content: space-around; margin-top: 20px; }
        .profile-stats div { text-align: center; }
        .profile-stats div strong { font-size: 20px; display: block; margin-bottom: 4px; }
        .card { margin: 25px 20px; padding: 15px; background: white; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); overflow: hidden; }
        .card .menu-item { display: flex; align-items: center; padding: 12px; border-bottom: 1px solid #eee; transition: 0.3s; cursor: pointer; text-decoration: none; color: #2c3e50; }
        .card .menu-item:last-child { border-bottom: none; }
        .card .menu-item:hover { background: #f2f2f2; }
        .card img { width: 26px; margin-right: 15px; }
        .logout-btn { width: 90%; max-width: 350px; margin: 30px auto; padding: 12px; background: #e74c3c; color: white; font-size: 16px; font-weight: bold; border: none; border-radius: 30px; display: block; cursor: pointer; transition: 0.3s; }
        .logout-btn:hover { background: #c0392b; }
        .bottom-nav { position: fixed; bottom: 0; left: 0; right: 0; background: white; display: flex; justify-content: space-around; border-top: 1px solid #eee; padding: 8px 0; box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05); }
        .bottom-nav a { text-align: center; text-decoration: none; color: #333; font-size: 12px; font-weight: 500; display: flex; flex-direction: column; align-items: center; }
        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }
        .bottom-nav a.active { color: #2980b9; } 
        @media (max-width: 768px) { .profile-header h2 { font-size: 20px; } .profile-stats div strong { font-size: 16px; } }


 .install-button {
            display: flex;
            align-items: center;
            padding: 12px;
            border-bottom: 1px solid #eee;
            transition: 0.3s;
            cursor: pointer;
            text-decoration: none;
            color: #2c3e50;
            background-color: #e0f2fe; 
        }
        .install-button:hover {
            background: #bae6fd;
        }


    </style>
</head>
<body>

<div class="profile-header">
    <img src="<?php echo htmlspecialchars($user_stats['avatar_url']); ?>" alt="Avatar">
    <h2><?php echo htmlspecialchars($user_stats['username']); ?></h2>
    <div class="profile-stats">
        <div>
            <strong><?php echo htmlspecialchars($user_stats['matches_played']); ?></strong>
            Played
        </div>
        <div>
            <strong>৳<?php echo htmlspecialchars(number_format($user_stats['balance'], 2)); ?></strong>
            Balance
        </div>
        <div>
            <strong><?php echo htmlspecialchars($user_stats['total_wins']); ?></strong>
            Wins
        </div>
    </div>
</div>

<div class="card">
    

   <a id="install-app-button" class="install-button">
            <img src="images/icons/download.png" alt="Install"> 
            <span>Install App</span>
        </a>


    <a href="wallet.php" class="menu-item"><img src="images/icons/wallet.png"> Wallet</a>
    <a href="withdraw.php" class="menu-item"><img src="images/icons/withdraw.png"> Withdraw</a>
    <a href="refer.php" class="menu-item"><img src="images/icons/refer.png"> Refer & Earn</a>
    <a href="my-profile-edit.php" class="menu-item"><img src="images/icons/user.png"> My Profile</a>
    <a href="top-players.php" class="menu-item"><img src="images/icons/star.png"> Top Players</a>
    <a href="all_match_rules.php" class="menu-item"><img src="images/icons/rules.png"> All Match Rules</a>
    <a href="http://t.me/raf1n_12" target="_blank" class="menu-item"><img src="images/icons/dev.png"> Developer Info</a>
</div>


<form method="post" action="logout.php">
    <button type="submit" class="logout-btn">Logout</button>
</form>

 <div id="ios-install-instructions" style="display: none; position: fixed; bottom: 0; left: 0; width: 100%; background: #333; color: white; text-align: center; padding: 20px; z-index: 10001;">
        <h4>Install on your iPhone</h4>
        <p>Tap the 'Share' icon in your browser, then scroll down and tap 'Add to Home Screen'.</p>
        <button id="close-ios-instructions" style="background: #555; color: white; border: none; padding: 8px 15px; border-radius: 5px; margin-top: 10px;">Close</button>
    </div>

<div class="bottom-nav">
    <a href="home.php"><img src="icons/play.png"><span>Play</span></a>
    <a href="my-matches.php"><img src="icons/match.png"><span>My Matches</span></a>
    <a href="results.php"><img src="icons/results.png"><span>Results</span></a>
    
    <a href="profile.php" class="active"><img src="icons/profile.png"><span>Profile</span></a>
</div>

<script>

document.addEventListener('DOMContentLoaded', () => {
            const installButton = document.getElementById('install-app-button');
            const iosInstructions = document.getElementById('ios-install-instructions');
            const closeIosBtn = document.getElementById('close-ios-instructions');

            const isIOS = () => /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;

            
            const isInStandaloneMode = () => ('standalone' in window.navigator) && (window.navigator.standalone);
            if (isInStandaloneMode()) {
                installButton.style.display = 'none';
            }

            installButton.addEventListener('click', async () => {
                
                if (isIOS()) {
                    
                    iosInstructions.style.display = 'block';
                } 
                
                else if (window.deferredPrompt) {
                    
                    const promptEvent = window.deferredPrompt;
                    promptEvent.prompt(); 
                    await promptEvent.userChoice;
                    window.deferredPrompt = null; 
                    installButton.style.display = 'none'; 
                } else {
                    
                    alert  ("অ্যাপটি ইন্সটল করার নিয়ম:\n\n১. ব্রাউজার (Chrome) ওপেন করে (profile) অপশনে যান।\n২. ব্রাউজারের মেনু বাটন ( ⋮ ) ক্লিক করুন\n৩. (Add to Home Screen) অপশনটি খুঁজে ট্যাপ করুন।\n৪. তারপর (Install) বাটনে ক্লিক করুন।\n৫. এবার অ্যাপটি আপনার ফোনে ইন্সটল হয়ে যাবে।") ;
                }
            });

            
            if (closeIosBtn) {
                closeIosBtn.addEventListener('click', () => {
                    iosInstructions.style.display = 'none';
                });
            }
        });

</script>

</body>
</html>