 <?php
// We need the session to ensure only a logged-in user (like you) can use this tool.
require_once 'session_check.php';

$response_message = '';
$response_type = 'info';

// Check if the form has been submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $amount = $_POST['amount'] ?? 0;
    $trx_id = $_POST['trx_id'] ?? '';

    // Basic validation
    if (empty($amount) || empty($trx_id) || !is_numeric($amount)) {
        $response_message = "Error: Please enter a valid Amount and Transaction ID.";
        $response_type = 'error';
    } else {
        // Fetch the secret key from the database to ensure we're using the correct one
        $settings = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'sms_gateway_secret'")->fetch_assoc();
        $secret_key = $settings['setting_value'];

        if (empty($secret_key)) {
            $response_message = "CRITICAL ERROR: The 'sms_gateway_secret' is not set in your admin settings page.";
            $response_type = 'error';
        } else {
            // --- This block simulates the Android App ---
            
            // The URL of your API endpoint
            $url = "https://" . $_SERVER['HTTP_HOST'] . "/receive_sms_data.php";
            
            // The data to be sent
            $post_data = [
                'amount' => $amount,
                'trx_id' => $trx_id
            ];
            
            // The required headers, including your secret key
            $headers = [
                'X-Secret-Key: ' . $secret_key
            ];
            
            // Initialize cURL
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data)); // Use http_build_query for form-data
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            // --- Process and display the response ---
            $response_data = json_decode($response, true);
            
            if ($http_code === 200 && isset($response_data['status']) && $response_data['status'] === 'success') {
                $response_type = 'success';
                $response_message = "<strong>Success!</strong> The server accepted the data. <br><strong>Response:</strong> " . htmlspecialchars($response);
            } else {
                $response_type = 'error';
                $response_message = "<strong>Failed!</strong> The server rejected the data. <br><strong>HTTP Status:</strong> {$http_code} <br><strong>Response:</strong> " . htmlspecialchars($response);
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SMS Gateway Tester</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root { --primary-color: #6c5ce7; --background-color: #f0f2f5; }
        body { font-family: 'Poppins', sans-serif; background: var(--background-color); margin: 0; padding: 20px; }
        .container { max-width: 600px; margin: 40px auto; }
        .card { background: white; padding: 30px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.07); }
        h2 { text-align: center; color: #1e293b; margin-top: 0; }
        p { color: #64748b; text-align: center; line-height: 1.6; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; }
        .form-group input { width: 100%; box-sizing: border-box; padding: 12px; border: 1px solid #d1d9e6; border-radius: 8px; font-size: 16px; }
        .btn-submit { display: block; width: 100%; background: var(--primary-color); color: white; border: none; padding: 14px; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; }
        .response-box { padding: 15px; border-radius: 8px; margin-top: 25px; border-left: 5px solid; word-wrap: break-word; }
        .response-box.success { background-color: #d1f7d1; color: #146c2d; border-color: #28a745; }
        .response-box.error { background-color: #f8d7da; color: #721c24; border-color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>SMS Gateway Tester</h2>
            <p>This form simulates the Android app. It sends the Amount and TrxID to the server to test if the "autopay" backend is working correctly.</p>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="amount">Amount (e.g., 50.00)</label>
                    <input type="number" step="0.01" name="amount" id="amount" required>
                </div>
                <div class="form-group">
                    <label for="trx_id">Transaction ID (e.g., ABC123XYZ)</label>
                    <input type="text" name="trx_id" id="trx_id" required>
                </div>
                <button type="submit" class="btn-submit">Send Test Data</button>
            </form>

            <?php if (!empty($response_message)): ?>
                <div class="response-box <?php echo $response_type; ?>">
                    <?php echo $response_message; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html