<?php


session_start();
require_once 'db_connect.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];


$sql = "SELECT amount, type, status, description, transaction_date 
        FROM transactions 
        WHERE user_id = ? AND (type = 'deposit' OR type = 'withdrawal')
        ORDER BY transaction_date DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();


$deposits = [];
$withdrawals = [];
while ($row = $result->fetch_assoc()) {
    if ($row['type'] == 'deposit') {
        $deposits[] = $row;
    } else { 
        $withdrawals[] = $row;
    }
}
$conn->close();
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>My Transactions</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root {
            --primary-color: #7c3aed;
            --background-color: #f4f4f9;
            --card-background: #ffffff;
            --text-primary: #2c3e50;
            --text-secondary: #555;
            --status-success: #27ae60;
            --status-pending: #f39c12;
            --status-failed: #e74c3c;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--background-color);
            margin: 0;
            padding: 20px;
        }
        .page-header {
            text-align: center;
            color: var(--text-primary);
            margin-bottom: 30px;
            font-size: 24px;
            font-weight: 600;
        }
        .tabs {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 25px;
        }
        .tab-btn {
            padding: 10px 25px;
            border: none;
            border-radius: 25px;
            font-weight: 500;
            cursor: pointer;
            font-size: 15px;
            background: #e0e0e0;
            color: var(--text-secondary);
            transition: all 0.3s ease;
        }
        .tab-btn.active {
            background: var(--primary-color);
            color: white;
            box-shadow: 0 4px 10px rgba(124, 58, 237, 0.4);
            transform: translateY(-2px);
        }
        .history-panel { display: none; }
        .history-panel.active { display: block; animation: fadeIn 0.5s; }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }

        .history-card {
            background: var(--card-background);
            border-radius: 12px;
            padding: 15px 20px;
            margin-bottom: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.06);
            border-left: 5px solid; 
        }
        .history-card.status-completed { border-left-color: var(--status-success); }
        .history-card.status-pending { border-left-color: var(--status-pending); }
        .history-card.status-failed, .history-card.status-canceled { border-left-color: var(--status-failed); }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }
        .amount {
            font-weight: 600;
            font-size: 18px;
            color: var(--text-primary);
        }
        .status {
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
        }
        .status.completed { color: var(--status-success); }
        .status.pending { color: var(--status-pending); }
        .status.failed, .status.canceled { color: var(--status-failed); }

        .info {
            font-size: 13px;
            color: #6c757d;
        }
        p.empty-msg {
            text-align: center;
            color: #888;
            font-size: 15px;
            margin-top: 40px;
        }
    </style>
</head>
<body>

<h2 class="page-header">MY TRANSACTION HISTORY</h2>

<div class="tabs">
    <button class="tab-btn active" onclick="showTab('add')">Add Money</button>
    <button class="tab-btn" onclick="showTab('withdraw')">Withdraw</button>
</div>


<div id="add" class="history-panel active">
    <?php if (empty($deposits)): ?>
        <p class="empty-msg">No "Add Money" transactions found.</p>
    <?php else: ?>
        <?php foreach ($deposits as $txn): ?>
            <div class="history-card status-<?php echo strtolower($txn['status']); ?>">
                <div class="card-header">
                    <span class="amount">BDT <?php echo htmlspecialchars(number_format($txn['amount'], 2)); ?></span>
                    <span class="status <?php echo strtolower($txn['status']); ?>"><?php echo htmlspecialchars($txn['status']); ?></span>
                </div>
                <div class="info">
                    <?php echo date("d F Y, h:i A", strtotime($txn['transaction_date'])); ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>


<div id="withdraw" class="history-panel">
    <?php if (empty($withdrawals)): ?>
        <p class="empty-msg">No "Withdraw" transactions found.</p>
    <?php else: ?>
        <?php foreach ($withdrawals as $txn): ?>
            <div class="history-card status-<?php echo strtolower($txn['status']); ?>">
                <div class="card-header">
                    
                    <span class="amount">BDT <?php echo htmlspecialchars(number_format(abs($txn['amount']), 2)); ?></span>
                    <span class="status <?php echo strtolower($txn['status']); ?>"><?php echo htmlspecialchars($txn['status']); ?></span>
                </div>
                <div class="info">
                    <?php echo date("d F Y, h:i A", strtotime($txn['transaction_date'])); ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<script>
    
    function showTab(tab) {
        document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
        document.querySelectorAll('.history-panel').forEach(panel => panel.classList.remove('active'));

        document.querySelector(`[onclick="showTab('${tab}')"]`).classList.add('active');
        document.getElementById(tab).classList.add('active');
    }
</script>

</body>
</html>