
<?php
session_start();
if (!isset($_SESSION['moderator_id'])) {
    header("Location: index.php");
    exit();
}
require_once '../db_connect.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Moderator Panel</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
        :root {
            --primary: #6366F1;
            --primary-hover: #4F46E5;
            --secondary: #6B7280;
            --background: #F3F4F6;
            --sidebar-bg: #1F2937;
            --sidebar-link: #D1D5DB;
            --sidebar-link-hover: #F9FAFB;
            --card-bg: #FFFFFF;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--background);
            margin: 0;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: var(--sidebar-bg);
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            padding-top: 20px;
            transition: transform 0.3s ease;
            z-index: 1000;
        }
        .sidebar .logo {
            text-align: center;
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 30px;
            color: white;
        }
        .sidebar nav a {
            display: block;
            padding: 15px 20px;
            color: var(--sidebar-link);
            text-decoration: none;
            font-weight: 500;
            transition: background-color 0.2s, color 0.2s;
            border-left: 3px solid transparent;
        }
        .sidebar nav a:hover {
            background-color: #374151;
            color: var(--sidebar-link-hover);
        }
        .sidebar nav a.active {
            background-color: var(--primary);
            color: white;
            border-left: 3px solid #A5B4FC;
        }
        .main-content {
            margin-left: 250px;
            width: calc(100% - 250px);
            padding: 20px;
            transition: margin-left 0.3s ease;
        }
        .top-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: var(--card-bg);
            padding: 15px 25px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            margin-bottom: 25px;
        }
        .top-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .top-header .admin-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .top-header .admin-info a {
            background: #eef2ff;
            color: var(--primary);
            padding: 8px 15px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: background 0.2s;
        }
        .top-header .admin-info a:hover {
            background: #e0e7ff;
        }
        .menu-toggle {
            display: none;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 5px;
            padding: 8px 12px;
            cursor: pointer;
            font-size: 16px;
        }
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
                width: 100%;
            }
            .menu-toggle {
                display: block;
            }
            .overlay.active {
                display: block;
            }
        }
    </style>
</head>
<body>
    <div class="overlay" id="overlay"></div>
    <div class="sidebar" id="sidebar">
        <div class="logo">Moderator</div>
        <?php $current_page = basename($_SERVER['PHP_SELF']); ?>
        <nav>
            <a href="tournaments.php" class="<?php if(in_array($current_page, ['tournaments.php', 'match_list_admin.php', 'tournament_form.php', 'view_registrations.php', 'add_winners.php'])) echo 'active'; ?>">Tournaments</a>
        </nav>
    </div>
    <div class="main-content">
        <div class="top-header">
            <button class="menu-toggle" id="menuToggle">☰ Menu</button>
            <h1><?php echo $page_title ?? 'Dashboard'; ?></h1>
            <div class="admin-info">
                <span>Welcome, <strong><?php echo htmlspecialchars($_SESSION['moderator_username']); ?></strong></span>
                <a href="logout.php">Logout</a>
            </div>
        </div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');
        
        menuToggle.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        });
        
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });
        
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });
    });
</script>
