<?php
/*
 * Tournament Delete Handler
 * /admin/tournament_delete.php
 */
session_start();

// --- Security Check: Ensure admin is logged in ---
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

// --- Check if the request is a POST request and an ID is provided ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id'])) {
    
    require_once '../db_connect.php';
    
    $tournament_id = (int)$_POST['id'];

    // --- Prepare and execute the DELETE statement ---
    // Using a prepared statement is safer.
    $sql = "DELETE FROM tournaments WHERE id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("i", $tournament_id);
        
        if ($stmt->execute()) {
            // Success! Redirect back to the tournament list.
            header("Location: tournaments.php?status=deleted");
            exit();
        } else {
            // Optional: Handle execution error
            die("Error executing delete statement: " . $stmt->error);
        }
        $stmt->close();
    } else {
        // Optional: Handle statement preparation error
        die("Error preparing delete statement: " . $conn->error);
    }
    
    $conn->close();

} else {
    // If not a POST request or no ID, just redirect back.
    header("Location: tournaments.php");
    exit();
}
?>