<?php
/*
 * Admin Header (with Desktop View Toggle Logic and Mobile Support)
 * /admin/header.php
 */
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}
require_once '../db_connect.php';

// --- Viewport Configuration ---
$view_mode = $_COOKIE['adminViewMode'] ?? 'responsive';
$viewport_content = ($view_mode === 'desktop') 
    ? 'width=1200' 
    : 'width=device-width, initial-scale=1.0';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="<?php echo $viewport_content; ?>">
    <title>Admin Panel</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

    <style>
        /* --- Modern Admin Panel CSS --- */
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
        :root {
            --primary: #6366F1;
            --primary-hover: #4F46E5;
            --secondary: #6B7280;
            --background: #F3F4F6;
            --sidebar-bg: #1F2937;
            --sidebar-link: #D1D5DB;
            --sidebar-link-hover: #F9FAFB;
            --card-bg: #FFFFFF;
        }
        * {
            box-sizing: border-box;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--background);
            margin: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: 250px;
            background-color: var(--sidebar-bg);
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            padding-top: 20px;
            transition: transform 0.3s ease;
            z-index: 1000;
        }
        
        /* Mobile Menu Button */
        .mobile-menu-btn {
            display: none;
            background: var(--primary);
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 15px;
        }
        
        .sidebar .logo {
            text-align: center;
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 30px;
            color: white;
        }
        .sidebar nav a {
            display: block;
            padding: 15px 20px;
            color: var(--sidebar-link);
            text-decoration: none;
            font-weight: 500;
            transition: background-color 0.2s, color 0.2s;
            border-left: 3px solid transparent;
        }
        .sidebar nav a:hover {
            background-color: #374151;
            color: var(--sidebar-link-hover);
        }
        .sidebar nav a.active {
            background-color: var(--primary);
            color: white;
            border-left: 3px solid #A5B4FC;
        }
        
        /* Main Content Area */
        .main-content {
            margin-left: 250px; /* Same as sidebar width */
            width: calc(100% - 250px);
            padding: 20px;
            transition: margin-left 0.3s ease;
        }
        
        /* Top Header */
        .top-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: var(--card-bg);
            padding: 15px 25px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            margin-bottom: 25px;
            flex-wrap: wrap;
        }
        .top-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
            flex: 1;
            min-width: 200px;
        }
        .top-header .admin-info {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-wrap: wrap;
            justify-content: flex-end;
        }
        .top-header .admin-info a {
            background: #eef2ff;
            color: var(--primary);
            padding: 8px 15px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: background 0.2s;
        }
        .top-header .admin-info a:hover {
            background: #e0e7ff;
        }
        
        /* Mobile Styles */
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.open {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
                width: 100%;
            }
            
            .mobile-menu-btn {
                display: inline-block;
            }
            
            .top-header {
                padding: 15px;
            }
            
            .top-header .admin-info {
                margin-top: 10px;
                width: 100%;
                justify-content: space-between;
            }
        }
        
        /* Overlay for mobile menu */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 999;
            display: none;
        }
        
        .sidebar-overlay.open {
            display: block;
        }
    </style>

    <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js" defer></script>
    <script>
        window.OneSignalDeferred = window.OneSignalDeferred || [];
        OneSignalDeferred.push(async function(OneSignal) {
            await OneSignal.init({
                appId: "9252b7ad-8567-4e65-9b1e-eddab5d90201",
            });
        });
        
        // Mobile menu toggle function
        function toggleMobileMenu() {
            const sidebar = document.querySelector('.sidebar');
            const overlay = document.querySelector('.sidebar-overlay');
            sidebar.classList.toggle('open');
            overlay.classList.toggle('open');
        }
        
        // Close sidebar when clicking outside
        document.addEventListener('DOMContentLoaded', function() {
            const overlay = document.querySelector('.sidebar-overlay');
            overlay.addEventListener('click', toggleMobileMenu);
        });
    </script>
</head>
<body>
    <div class="sidebar-overlay"></div>
    <div class="sidebar">
        <div class="logo">Admin</div>
        <?php $current_page = basename($_SERVER['PHP_SELF']); ?>

        <nav>
            <a href="index.php" class="<?php if($current_page == 'index.php') echo 'active'; ?>">Dashboard</a>
            <a href="tournaments.php" class="<?php if(in_array($current_page, ['tournaments.php', 'tournament_form.php', 'view_registrations.php', 'add_winners.php'])) echo 'active'; ?>">Tournaments</a>
            <a href="users.php" class="<?php if($current_page == 'users.php') echo 'active'; ?>">Users</a>
            <a href="deposits.php" class="<?php if($current_page == 'deposits.php') echo 'active'; ?>">Deposits</a>
            <a href="withdrawals.php" class="<?php if($current_page == 'withdrawals.php') echo 'active'; ?>">Withdrawals</a>
            <a href="settings.php" class="<?php if($current_page == 'settings.php') echo 'active'; ?>">Settings</a>
            <a href="sliders.php" class="<?php if($current_page == 'sliders.php') echo 'active'; ?>">Sliders</a>
            <a href="rules.php" class="<?php if($current_page == 'rules.php') echo 'active'; ?>">Match Rules</a>
        </nav>
    </div>
    <div class="main-content">
        <div class="top-header">
            <button class="mobile-menu-btn" onclick="toggleMobileMenu()">☰ Menu</button>
            <h1><?php echo $page_title ?? 'Dashboard'; ?></h1>
            <div class="admin-info">
                <span>Welcome, <strong><?php echo htmlspecialchars($_SESSION['admin_username']); ?></strong></span>
                <a href="logout.php">Logout</a>
            </div>
        </div>