<?php
$page_title = "Edit User";
require_once 'header.php';

$user_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$message = '';
$message_type = 'error';

// Fetch user data if in edit mode
if ($user_id > 0) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    if (!$user) { die("User not found."); }
} else { die("No user ID specified."); }

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $balance = (float)$_POST['balance'];
    $is_banned = isset($_POST['is_banned']) ? 1 : 0;
    
    // Base SQL
    $sql = "UPDATE users SET first_name=?, last_name=?, balance=?, is_banned=? WHERE id=?";
    $params = [$first_name, $last_name, $balance, $is_banned, $user_id];
    $types = "ssdii";

    // Optional: Password update
    if (!empty($_POST['password'])) {
        if (strlen($_POST['password']) < 6) {
            $message = "Password must be at least 6 characters long.";
        } else {
            $hashed_password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $sql = "UPDATE users SET first_name=?, last_name=?, balance=?, is_banned=?, password=? WHERE id=?";
            $params = [$first_name, $last_name, $balance, $is_banned, $hashed_password, $user_id];
            $types = "ssdisi";
        }
    }
    
    if (empty($message)) {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        if ($stmt->execute()) {
            $message = "User updated successfully!";
            $message_type = 'success';
            // Re-fetch user data to show updated values
            $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $user = $stmt->get_result()->fetch_assoc();
        } else {
            $message = "Database update failed.";
        }
    }
}

$conn->close();
?>
<style>
    .form-container { max-width: 600px; margin: auto; background: var(--card-bg); padding: 30px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
    .form-group { display: flex; flex-direction: column; margin-bottom: 20px; }
    .form-group label { font-weight: 500; margin-bottom: 8px; color: #374151; }
    .form-group input { padding: 10px; border: 1px solid #D1D5DB; border-radius: 8px; font-size: 14px; }
    .form-group input[readonly] { background: #f3f4f6; cursor: not-allowed; }
    .checkbox-group { flex-direction: row; align-items: center; gap: 10px; }
    .form-actions { margin-top: 25px; display: flex; justify-content: space-between; align-items: center; }
    .btn-submit { background: var(--primary); color: white; padding: 12px 25px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; }
    .btn-back { color: var(--secondary); text-decoration: none; font-weight: 500; }
    .msg { padding: 12px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; }
    .msg.success { background: #D1FAE5; color: #065F46; }
    .msg.error { background: #FEE2E2; color: #991B1B; }
</style>

<div class="form-container">
    <h2>Editing User: <?php echo htmlspecialchars($user['username']); ?></h2>
    
    <?php if ($message): ?>
        <div class="msg <?php echo $message_type; ?>"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label>Username</label>
            <input type="text" value="<?php echo htmlspecialchars($user['username']); ?>" readonly>
        </div>
        <div class="form-group">
            <label for="first_name">First Name</label>
            <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($user['first_name']); ?>">
        </div>
        <div class="form-group">
            <label for="last_name">Last Name</label>
            <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($user['last_name']); ?>">
        </div>
        <div class="form-group">
            <label for="balance">Balance</label>
            <input type="number" step="0.01" id="balance" name="balance" value="<?php echo htmlspecialchars($user['balance']); ?>">
        </div>
        <div class="form-group">
            <label for="password">New Password (optional)</label>
            <input type="password" id="password" name="password" placeholder="Leave blank to keep current password">
        </div>
        <div class="form-group checkbox-group">
            <input type="checkbox" id="is_banned" name="is_banned" value="1" <?php if($user['is_banned']) echo 'checked'; ?>>
            <label for="is_banned" style="margin-bottom: 0;">Is Banned</label>
        </div>
        
        <div class="form-actions">
            <a href="users.php" class="btn-back">← Back to Users</a>
            <button type="submit" class="btn-submit">Save Changes</button>
        </div>
    </form>
</div>

<?php require_once 'footer.php'; ?>