<?php
$page_title = "User Management";
require_once 'header.php'; // Includes security check and db connection

// --- ACTION HANDLER for Ban/Unban ---
if (isset($_GET['action']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $user_id = (int)$_GET['id'];
    $new_status = ($action === 'ban') ? 1 : 0; // 1 for banned, 0 for active

    if ($user_id > 0) {
        $sql = "UPDATE users SET is_banned = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ii", $new_status, $user_id);
        $stmt->execute();
        $stmt->close();
        // Redirect to the same page to clear the GET parameters from the URL
        echo '<script>window.location.href = "users.php";</script>';
    }
}

// --- Search and Pagination Logic ---
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';
$where_clause = '';
$search_param = '';

if (!empty($search_query)) {
    $where_clause = "WHERE username LIKE ? OR email LIKE ?";
    $search_param = "%" . $search_query . "%";
}

// --- Fetch users from the database (including new is_banned column) ---
$sql = "SELECT id, username, first_name, last_name, email, mobile_number, balance, created_at, is_banned 
        FROM users 
        $where_clause
        ORDER BY created_at DESC";

$stmt = $conn->prepare($sql);
if (!empty($search_query)) {
    $stmt->bind_param("ss", $search_param, $search_param);
}
$stmt->execute();
$result = $stmt->get_result();
$users = [];
if ($result) {
    while($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}
$stmt->close();
$conn->close();
?>

<style>
    /* Base Styles (Mobile First) */
    .page-controls { 
        display: flex; 
        flex-direction: column;
        gap: 15px;
        margin-bottom: 20px; 
    }
    
    .search-form { 
        display: flex; 
        flex-direction: column;
        gap: 10px; 
        width: 100%;
    }
    
    .search-form input { 
        padding: 12px; 
        border: 1px solid #D1D5DB; 
        border-radius: 8px; 
        font-size: 16px; 
        width: 100%;
        box-sizing: border-box;
    }
    
    .search-form button { 
        background: var(--primary); 
        color: white; 
        border: none; 
        padding: 12px; 
        border-radius: 8px; 
        cursor: pointer; 
        font-weight: 500; 
        font-size: 16px;
        width: 100%;
    }
    
    .data-table-container {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .data-table { 
        width: 100%; 
        min-width: 600px; /* Minimum width for table */
        background: var(--card-bg); 
        border-radius: 12px; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.05); 
        border-collapse: collapse; 
    }
    
    .data-table th, 
    .data-table td { 
        padding: 12px 10px; 
        text-align: left; 
        border-bottom: 1px solid #e5e7eb; 
        vertical-align: middle; 
    }
    
    .data-table th { 
        background: #f9fafb; 
        font-size: 14px; 
        color: var(--secondary); 
        text-transform: uppercase; 
        font-weight: 600; 
    }
    
    .balance { 
        font-weight: bold; 
    }
    
    /* Status and Action Styles */
    .status-label { 
        padding: 6px 12px; 
        border-radius: 20px; 
        font-size: 14px; 
        font-weight: 600; 
        color: white; 
        display: inline-block;
    }
    
    .status-active { 
        background: #10B981; 
    }
    
    .status-banned { 
        background: #EF4444; 
    }
    
    .action-links { 
        display: flex; 
        flex-direction: column;
        gap: 8px; 
    }
    
    .action-links a, 
    .action-links button { 
        text-decoration: none; 
        padding: 8px 12px; 
        border-radius: 6px; 
        font-weight: 500; 
        font-size: 14px; 
        text-align: center;
    }
    
    .edit-link { 
        color: #2563EB; 
        background: #DBEAFE; 
    }
    
    .ban-link { 
        color: #D97706; 
        background: #FEF3C7; 
    }
    
    .unban-link { 
        color: #059669; 
        background: #D1FAE5; 
    }
    
    .delete-link { 
        color: #DC2626; 
        background: #FEE2E2; 
        border: none; 
        cursor: pointer; 
        font-family: 'Inter', sans-serif; 
        width: 100%;
    }
    
    /* Responsive adjustments for tablets and desktops */
    @media (min-width: 768px) {
        .page-controls {
            flex-direction: row;
            justify-content: space-between;
            align-items: center;
        }
        
        .search-form {
            flex-direction: row;
            width: auto;
        }
        
        .search-form input {
            width: 300px;
        }
        
        .search-form button {
            width: auto;
        }
        
        .action-links {
            flex-direction: row;
        }
        
        .action-links a,
        .action-links button {
            padding: 5px 10px;
        }
    }
</style>

<div class="page-controls">
    <form method="GET" action="users.php" class="search-form">
        <input type="text" name="search" placeholder="Search by Username or Email..." value="<?php echo htmlspecialchars($search_query); ?>">
        <button type="submit">Search</button>
    </form>
</div>

<div class="data-table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Username</th>
                <th>Email</th>
                <th>Balance</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($users)): ?>
                <tr><td colspan="5" style="text-align:center; padding: 30px;">No users found.</td></tr>
            <?php else: ?>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td>
                            <strong><?php echo htmlspecialchars($user['username']); ?></strong>
                            <br>
                            <small><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></small>
                        </td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td class="balance">Tk <?php echo htmlspecialchars(number_format($user['balance'], 2)); ?></td>
                        <td>
                            <?php if ($user['is_banned']): ?>
                                <span class="status-label status-banned">Banned</span>
                            <?php else: ?>
                                <span class="status-label status-active">Active</span>
                            <?php endif; ?>
                        </td>
                        <td class="action-links">
                            <a href="user_form.php?id=<?php echo $user['id']; ?>" class="edit-link">Edit</a>
                            
                            <?php if ($user['is_banned']): ?>
                                <a href="users.php?action=unban&id=<?php echo $user['id']; ?>" class="unban-link" onclick="return confirm('Are you sure you want to unban this user?')">Unban</a>
                            <?php else: ?>
                                <a href="users.php?action=ban&id=<?php echo $user['id']; ?>" class="ban-link" onclick="return confirm('Are you sure you want to ban this user?')">Ban</a>
                            <?php endif; ?>
                            
                            <form method="POST" action="user_delete.php" onsubmit="return confirm('WARNING: This will permanently delete the user and all their related data. Are you absolutely sure?');">
                                <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                <button type="submit" class="delete-link">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require_once 'footer.php'; ?>