<?php
/*
 * Admin Footer (with Desktop View Toggle)
 * /admin/footer.php
 */
?>
    </div> <!-- Close .main-content -->
    
    <!-- NEW: HTML and JS for the View Mode Toggle -->
    <div id="view-mode-container" style="position: fixed; bottom: 10px; right: 10px; z-index: 1001;">
        <button id="view-mode-toggle" style="background: #333; color: white; border: none; padding: 10px 15px; border-radius: 8px; cursor: pointer; font-family: 'Inter', sans-serif; font-size: 14px; box-shadow: 0 4px 10px rgba(0,0,0,0.2);">
            Loading View...
        </button>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const toggleButton = document.getElementById('view-mode-toggle');
            
            // Get the current mode from localStorage, default to 'responsive'
            let currentMode = localStorage.getItem('adminViewMode') || 'responsive';

            // Function to update the button text
            function updateButtonText() {
                if (currentMode === 'desktop') {
                    toggleButton.textContent = 'Switch to Mobile View';
                } else {
                    toggleButton.textContent = 'Switch to Desktop View';
                }
            }

            // Set the initial button text when the page loads
            updateButtonText();

            // Add the click event listener to the button
            toggleButton.addEventListener('click', function () {
                // Switch the mode
                const newMode = (currentMode === 'desktop') ? 'responsive' : 'desktop';
                
                // Save the new choice in localStorage for persistence
                localStorage.setItem('adminViewMode', newMode);
                
                // Also save the choice in a Cookie so PHP can read it on the NEXT page load
                // The path=/ ensures the cookie is available across the entire admin folder
                document.cookie = `adminViewMode=${newMode}; path=/`;

                // Reload the page for the new viewport meta tag to take effect
                location.reload();
            });
        });
    </script>

</body>
</html>