 <?php

require_once 'session_check.php'; 

$user_id = $_SESSION['user_id'];


$user_sql = "SELECT username, balance FROM users WHERE id = $user_id";
$user_result = $conn->query($user_sql);
if (!$user_result) {
    die("DATABASE ERROR [1]: Could not execute the user query. Error: " . $conn->error);
}
$user = $user_result->fetch_assoc();
$user_balance = number_format($user['balance'], 2);


$sliders_sql = "SELECT image_url, link_url FROM sliders WHERE is_active = 1 ORDER BY sort_order ASC";
$sliders_result = $conn->query($sliders_sql);
if (!$sliders_result) {
    die("DATABASE ERROR [2]: Could not execute the sliders query. Check if the 'sliders' table exists. Error: " . $conn->error);
}
$sliders = [];
while ($row = $sliders_result->fetch_assoc()) { $sliders[] = $row; }


$notice_sql = "SELECT setting_value FROM settings WHERE setting_key = 'scrolling_notice' LIMIT 1";
$notice_result = $conn->query($notice_sql);
if (!$notice_result) {
    die("DATABASE ERROR [3]: Could not execute the notice query. Check if the 'settings' table exists. Error: " . $conn->error);
}
$notice_text = ($notice_result->num_rows > 0) ? $notice_result->fetch_assoc()['setting_value'] : "Welcome!";


// --- NEW: Fetch the Support Link ---
$support_link_sql = "SELECT setting_value FROM settings WHERE setting_key = 'support_link' LIMIT 1";
$support_link_result = $conn->query($support_link_sql);
$support_link = ($support_link_result->num_rows > 0) ? $support_link_result->fetch_assoc()['setting_value'] : '#';


$match_counts_sql = "SELECT category, COUNT(id) as count FROM tournaments WHERE status = 'upcoming' GROUP BY category";
$match_counts_result = $conn->query($match_counts_sql);
if (!$match_counts_result) {
    die("DATABASE ERROR [4]: Could not execute the match counts query. Check if the 'tournaments' table exists. Error: " . $conn->error);
}
$match_counts = [];
while ($row = $match_counts_result->fetch_assoc()) { $match_counts[$row['category']] = $row['count']; }


$conn->close();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">


    <title>Home</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="manifest" href="/manifest.webmanifest" crossorigin="use-credentials">
    <meta name="theme-color" content="#24243e">
    
    <style>
        
       * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            background: #f0f2f5;
            padding-bottom: 80px;
            overflow-x: hidden;
        }

        .header {
            background: linear-gradient(90deg, #1e3c72, #2a5298);
            color: white;
            padding: 20px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header-greeting h1 { font-size: 18px; font-weight: 600; margin: 0; }
        .header-greeting p { font-size: 14px; opacity: 0.8; margin: 4px 0 0; }
        .header-wallet { text-align: right; }
        .header-wallet a {
            background: rgba(255, 255, 255, 0.15);
            padding: 8px 12px;
            border-radius: 20px;
            text-decoration: none;
            color: white;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            transition: background 0.3s;
        }
        .header-wallet a:hover { background: rgba(255, 255, 255, 0.25); }
        .header-wallet img { width: 16px; margin-right: 6px; }
        
        
        .slider-wrapper { position: relative; overflow: hidden; height: 160px; }
        .slider-track { display: flex; transition: transform 0.5s ease-in-out; }
        .slider-track a { flex-shrink: 0; width: 100vw; }
        .slider-track img { width: 100%; height: 160px; object-fit: cover; }
        .dots { text-align: center; margin: 8px 0; }
        .dot { width: 8px; height: 8px; margin: 0 4px; background-color: #ccc; display: inline-block; border-radius: 50%; transition: background-color 0.3s; }
        .dot.active { background-color: #2a5298; }
        
        
        .notice-wrapper { background: #fff; padding: 10px 0; overflow: hidden; white-space: nowrap; width: 100%; margin: 10px 0; }
        .notice-text { display: inline-block; white-space: nowrap; color: #ff6f00; font-weight: bold; font-size: 14px; animation: scrollText 20s linear infinite; padding-left: 100%; }
        @keyframes scrollText { 0% { transform: translateX(0%); } 100% { transform: translateX(-100%); } }

        
        .section-title { padding: 0 15px; font-size: 18px; font-weight: bold; margin: 20px 0 10px; color: #333; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; padding: 0 15px; }
        .card { background: #fff; border-radius: 12px; overflow: hidden; text-decoration: none; color: #000; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08); transition: transform 0.2s ease, box-shadow 0.2s ease; }
        .card:hover { transform: translateY(-3px); box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12); }
        .card img { width: 100%; height: 100px; object-fit: cover; }
        .card .title { font-weight: 600; text-align: center; padding: 8px 8px 2px; font-size: 15px; }
        .card .matches { font-size: 12px; text-align: center; color: #666; padding-bottom: 10px; }

        
        .bottom-nav { position: fixed; bottom: 0; left: 0; right: 0; background: #fff; border-top: 1px solid #e0e0e0; display: flex; justify-content: space-around; padding: 8px 0; z-index: 999; }
        .bottom-nav a { text-align: center; font-size: 11px; color: #555; text-decoration: none; display: flex; flex-direction: column; align-items: center; }
        .bottom-nav a.active { color: #1e3c72; font-weight: 600; }
        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }

        
        .install-prompt-container { display: none; position: fixed; bottom: 0; left: 0; width: 100%; background: rgba(25, 25, 30, 0.9); backdrop-filter: blur(5px); color: white; z-index: 10000; padding: 20px; box-shadow: 0 -5px 20px rgba(0,0,0,0.3); border-top: 1px solid rgba(255, 255, 255, 0.1); animation: slideUp 0.5s ease-in-out; }
        @keyframes slideUp { from { transform: translateY(100%); } to { transform: translateY(0); } }
        .install-prompt-content { display: flex; align-items: center; justify-content: space-between; max-width: 600px; margin: auto; }
        .install-prompt-text { flex-grow: 1; padding-right: 15px; }
        .install-prompt-text h4 { margin: 0 0 5px 0; font-size: 16px; }
        .install-prompt-text p { margin: 0; font-size: 14px; color: #d1d5db; }
        .install-prompt-actions button { padding: 8px 16px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; margin-left: 10px; }
        #install-button { background-color: #6366F1; color: white; }
        #later-button { background-color: #4B5563; color: white; }
        #ios-install-prompt .install-prompt-text p { font-size: 13px; }
        #ios-install-prompt .install-prompt-actions { display: none; }

.support-container {
            position: fixed;
            bottom: 60px; 
            right: 20px;
            z-index: 1000;
        }
        
        .support-icon {
            width: 50px;
            height: 50px;
            background-color: #87CEEB ;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .support-icon:hover {
            background-color: #45a049;
            transform: scale(1.1);
        }
        
        .support-icon i {
            color: white;
            font-size: 24px;
        }
        
        
        .support-icon::after {
            content: "Need help?";
            position: absolute;
            right: 60px;
            top: 50%;
            transform: translateY(-50%);
            background-color: #333;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 14px;
            white-space: nowrap;
            opacity: 0;
            transition: opacity 0.3s;
        }
        
        .support-icon:hover::after {
            opacity: 1;
        }

        
    #preloader {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 99999;
        
        
        background: rgba(15, 12, 41, 0.8); 
        backdrop-filter: blur(8px);
        -webkit-backdrop-filter: blur(8px); 
        
        display: flex;
        justify-content: center;
        align-items: center;
        
        
        opacity: 1;
        visibility: visible;
        transition: opacity 0.5s ease, visibility 0.5s ease;
    }

    #preloader.fade-out {
        opacity: 0;
        visibility: hidden;
    }

    
    .loader-logo {
        width: 150px; 
        height: 150px;
    }
</style>



</head>
<body>


<div id="preloader">

<img src="/images/animated-logo.svg" alt="Loading..." class="loader-logo">
</div>



    
    <div class="header">
        <div class="header-greeting">
            <h1>Welcome, <?php echo htmlspecialchars($user['username']); ?>!</h1>
            <p>Ready to Dominate?</p>
        </div>
        <div class="header-wallet">
            <a href="wallet.php">
                <img src="https://img.icons8.com/material-outlined/24/ffffff/wallet.png" alt="wallet"/>
                <span>Tk <?php echo htmlspecialchars($user_balance); ?></span>
            </a>
        </div>
    </div>

    
    <div class="slider-wrapper">
        <div class="slider-track" id="sliderTrack">
            <?php foreach ($sliders as $slider): ?>
                <a href="<?php echo htmlspecialchars($slider['link_url']); ?>">
                    <img src="<?php echo htmlspecialchars($slider['image_url']); ?>" alt="slider" />
                </a>
            <?php endforeach; ?>
            <?php if (empty($sliders)): ?>
                 <a><img src="images/default-banner.jpg" alt="default banner"/></a>
            <?php endif; ?>
        </div>
    </div>
    <div class="dots" id="dots"></div>

    
    <div class="notice-wrapper">
        <div class="notice-text"><?php echo htmlspecialchars($notice_text); ?></div>
    </div>

    
    <div class="section-title">FREE FIRE</div>
    <div class="grid">
        <a class="card" href="match-list.php?category=br"><img src="images/b.jpeg" alt="BR Match"/><div class="title">BR Match</div><div class="matches"><?php echo $match_counts['br'] ?? 0; ?> matches available</div></a>
        <a class="card" href="match-list.php?category=cs"><img src="images/c.jpeg" alt="Clash Squad"/><div class="title">Clash Squad</div><div class="matches"><?php echo $match_counts['cs'] ?? 0; ?> matches available</div></a>
        <a class="card" href="match-list.php?category=lone"><img src="images/lon.jpeg" alt="Lone Wolf"/><div class="title">Lone Wolf</div><div class="matches"><?php echo $match_counts['lone'] ?? 0; ?> matches available</div></a>
        <a class="card" href="match-list.php?category=cs2"><img src="images/c2.jpeg" alt="CS 2 vs 2"/><div class="title">CS 2 VS 2</div><div class="matches"><?php echo $match_counts['cs2'] ?? 0; ?> matches available</div></a>
    </div>

    
    <div class="section-title">LUDO AND FREE MATCH</div>
    <div class="grid" style="padding-bottom: 20px">
        <a class="card" href="match-list.php?category=ludo"><img src="images/lud.jpeg" alt="Ludo"/><div class="title">Ludo</div><div class="matches"><?php echo $match_counts['ludo'] ?? 0; ?> matches available</div></a>
        <a class="card" href="match-list.php?category=free"><img src="images/fre.jpeg" alt="Free Match"/><div class="title">Free Match</div><div class="matches"><?php echo $match_counts['free'] ?? 0; ?> matches available</div></a>
    </div>

    
    <div class="bottom-nav">
        <a href="home.php" class="active"><img src="icons/play.png" /><span>Play</span></a>
        <a href="my-matches.php"><img src="icons/match.png" /><span>My Matches</span></a>
        <a href="results.php"><img src="icons/results.png" /><span>Results</span></a>
        <a href="profile.php"><img src="icons/profile.png" /><span>Profile</span></a>
    </div>

    

     <a href="<?php echo htmlspecialchars($support_link); ?>" target="_blank" class="support-container">
        <div class="support-icon" title="Get Support">
            <i class="fas fa-headset"></i>
        </div>
    </a>

    
    <script>
        let index = 0;
        const slides = document.querySelectorAll("#sliderTrack a");
        const dotsContainer = document.getElementById("dots");
        if (slides.length > 0) {
            slides.forEach((_, i) => { const dot = document.createElement("span"); dot.className = "dot" + (i === 0 ? " active" : ""); dotsContainer.appendChild(dot); });
            function showSlide(i) { document.getElementById("sliderTrack").style.transform = `translateX(-${i * 100}vw)`; document.querySelectorAll(".dot").forEach((d, idx) => d.classList.toggle("active", idx === i)); }
            function nextSlide() { index = (index + 1) % slides.length; showSlide(index); }
            if (slides.length > 1) { setInterval(nextSlide, 3000); }
        }
</script>


    
    
    <script>
        
        document.addEventListener('DOMContentLoaded', () => {
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('/sw.js')
                    .then(() => console.log('Service Worker Registered'));
            }

            
            window.addEventListener('beforeinstallprompt', (e) => {
                e.preventDefault(); 
                
                window.deferredPrompt = e; 
                console.log('Install prompt has been captured and is ready to use.');
            });
        });


    </script>


<script>
    
    window.onload = function() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            
            preloader.classList.add('fade-out');
            
            
            setTimeout(() => {
                preloader.style.display = 'none';
            }, 500); 
        }
    };
</script>

</body>
</html