<?php
require_once 'session_check.php';
$user_id = $_SESSION['user_id'];
$category = isset($_GET['category']) ? mysqli_real_escape_string($conn, $_GET['category']) : '';
if (empty($category)) { header("Location: home.php"); exit(); }

$category_map = ['br'=>'BR Match','cs'=>'Clash Squad','lone'=>'Lone Wolf','cs2'=>'CS 2 VS 2','ludo'=>'Ludo','free'=>'Free Match'];
$page_title = $category_map[$category] ?? 'Match List';

$sql = "SELECT 
            t.id, t.title, t.match_time, t.entry_fee, t.prize_pool, t.per_kill_prize, t.prize_details, 
            t.max_players, t.version, t.map, t.image_url, t.match_type, t.status,
            (SELECT COALESCE(SUM(slots_taken), 0) FROM registrations WHERE tournament_id = t.id) as players_joined,
            (SELECT COUNT(*) FROM registrations WHERE tournament_id = t.id AND user_id = {$user_id}) as is_joined,
            rd.room_id, rd.room_pass
        FROM tournaments t
        LEFT JOIN room_details rd ON t.id = rd.tournament_id
        WHERE t.category = ? AND t.status = 'upcoming'
        ORDER BY t.match_time ASC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $category);
$stmt->execute();
$matches_result = $stmt->get_result();
$matches = [];
while ($row = $matches_result->fetch_assoc()) {
    $matches[] = $row;
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');
        :root {
            --background-color: #f0f2f5;
            --card-background: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --accent-color: #e53e3e;
            --primary-color: #6c5ce7;
            --success-color: #38a169;
            --border-color: #e2e8f0;
        }
        body { font-family: 'Poppins', sans-serif; background-color: var(--background-color); margin: 0; padding: 15px; }
        .container { max-width: 500px; margin: 0 auto; }
        .top-bar { display: flex; align-items: center; margin-bottom: 20px; }
        .top-bar a { color: var(--text-primary); text-decoration: none; font-size: 20px; font-weight: 600; display: flex; align-items: center; gap: 8px; }
        .match-card { background: var(--card-background); border-radius: 12px; margin-bottom: 20px; overflow: hidden; color: var(--text-secondary); box-shadow: 0 5px 15px rgba(0,0,0,0.2); }
        .card-header { padding: 16px; display: flex; gap: 12px; align-items: flex-start; }
        .card-header img { width: 40px; height: 40px; border-radius: 8px; object-fit: cover; }
        .header-info { flex-grow: 1; }
        .header-info h3 { margin: 0 0 4px; font-size: 18px; color: var(--text-primary); }
        .header-info p { margin: 0; font-size: 13px; }
        .match-id { background-color: var(--primary-color); color: white; padding: 4px 10px; border-radius: 6px; font-size: 12px; font-weight: 600; }
        .details-grid { padding: 16px; display: grid; grid-template-columns: 1fr 1fr; gap: 16px; border-top: 1px solid var(--border-color); }
        .detail-item { font-size: 12px; text-transform: uppercase; color: var(--text-secondary); }
        .detail-item strong { display: block; font-size: 16px; color: var(--text-primary); font-weight: 600; text-transform: none; }
        .spots-section { padding: 16px; border-top: 1px solid var(--border-color); }
        .progress-bar { background: var(--border-color); height: 4px; border-radius: 2px; overflow: hidden; }
        .progress-bar .fill { height: 100%; background: var(--primary-color); border-radius: 2px; }
        .spots-text { display: flex; justify-content: space-between; font-size: 13px; margin-top: 8px; }
        .spots-text .joined-count { color: var(--text-primary); font-weight: 500; }
        .collapsible-container { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; padding: 16px; border-top: 1px solid var(--border-color); }
        details { background-color: var(--border-color); border-radius: 8px; }
        details summary { padding: 12px; font-weight: 600; color: var(--text-primary); cursor: pointer; display: flex; justify-content: space-between; list-style: none; }
        details summary::-webkit-details-marker { display: none; }
        details summary::after { content: '▾'; }
        details[open] summary::after { content: '▴'; }
        .collapsible-content { padding: 0 12px 12px; color: var(--text-secondary); border-top: 1px solid #2d3748; margin-top: 8px; padding-top: 8px; }
        .prize-item, .room-item { display: flex; justify-content: space-between; font-size: 14px; padding: 4px 0; }
        .prize-item strong, .room-item strong { color: var(--text-primary); }
        .countdown { background: var(--primary-color); color: var(--text-primary); text-align: center; padding: 12px; font-weight: 600; }
        .action-area { padding: 16px; border-top: 1px solid var(--border-color); }
        .action-button { display: block; width: 100%; padding: 12px; text-align: center; text-decoration: none; border: none; cursor: pointer; border-radius: 8px; font-size: 16px; font-weight: 600; }
        .btn-join { background-color: var(--primary-color); color: white; }
        .btn-joined { background-color: var(--success-color); color: white; }
        .btn-full { background-color: #4a5568; color: var(--text-secondary); cursor: not-allowed; }
    </style>
</head>
<body>
<div class="container">
    <div class="top-bar"><a href="home.php"><svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24"><path d="M15 18L9 12L15 6"/></svg><?php echo htmlspecialchars($page_title); ?></a></div>
    <?php if (empty($matches)): ?>
        <p style="color:white; text-align:center;">No matches available in this category yet.</p>
    <?php else: ?>
        <?php foreach ($matches as $match): ?>
            <div class="match-card">
                <div class="card-header">
                    <img src="<?php echo htmlspecialchars($match['image_url']); ?>" alt="Game">
                    <div class="header-info">
                        <h3><?php echo htmlspecialchars($match['title']); ?></h3>
                        <p>Time: <?php echo date("d/m/Y \A\\t h:i A", strtotime($match['match_time'])); ?></p>
                    </div>
                    <span class="match-id">#<?php echo htmlspecialchars($match['id']); ?></span>
                </div>
                <div class="details-grid">
                    <div class="detail-item">Total Prize<strong><?php echo htmlspecialchars($match['prize_pool']); ?></strong></div>
                    <div class="detail-item">Entry Type<strong><?php echo htmlspecialchars(ucfirst($match['match_type'])); ?></strong></div>
                    <div class="detail-item">Per Kill<strong><?php echo htmlspecialchars($match['per_kill_prize']); ?> TK</strong></div>
                    <div class="detail-item">Map<strong><?php echo htmlspecialchars($match['map']); ?></strong></div>
                    <div class="detail-item">Entry Fee<strong><?php echo htmlspecialchars($match['entry_fee']); ?> TK</strong></div>
                    <div class="detail-item">Version<strong><?php echo htmlspecialchars($match['version']); ?></strong></div>
                </div>
                <div class="spots-section">
                    <?php
                        $spots_filled = $match['players_joined'];
                        $total_spots = $match['max_players'];
                        $spots_left = $total_spots - $spots_filled;
                        $progress_percentage = ($total_spots > 0) ? ($spots_filled / $total_spots) * 100 : 0;
                    ?>
                    <div class="progress-bar"><div class="fill" style="width: <?php echo $progress_percentage; ?>%;"></div></div>
                    <div class="spots-text">
                        <span>Only <?php echo $spots_left; ?> Spots Left</span>
                        <span class="joined-count"><?php echo $spots_filled; ?>/<?php echo $total_spots; ?></span>
                    </div>
                </div>
             <div class="collapsible-container">
                    
                    <!-- THIS ENTIRE 'details' BLOCK IS NOW WRAPPED IN A PHP IF STATEMENT -->
                    <?php if ($match['is_joined']): ?>
                        <details>
                            <summary>Room Details</summary>
                            <div class="collapsible-content">
                                <?php if (!empty($match['room_id'])): ?>
                                    <div class="room-item"><span>Room ID:</span> <strong><?php echo htmlspecialchars($match['room_id']); ?></strong></div>
                                    <div class="room-item"><span>Password:</span> <strong><?php echo htmlspecialchars($match['room_pass']); ?></strong></div>
                                <?php else: ?>
                                    <p>Details will be available 5 mins before match start.</p>
                                <?php endif; ?>
                            </div>
                        </details>
                    <?php endif; ?>
                    <details>
                        <summary>Total Prize Details</summary>
                        <div class="collapsible-content">
                            <?php
                                $prize_data = json_decode($match['prize_details'], true);
                                if (is_array($prize_data) && !empty($prize_data)):
                                    foreach($prize_data as $prize):
                            ?>
                                <div class="prize-item"><span>Rank #<?php echo htmlspecialchars($prize['rank']); ?></span><strong><?php echo htmlspecialchars($prize['prize']); ?> TK</strong></div>
                            <?php endforeach; else: ?>
                                <p>No specific prize breakdown available.</p>
                            <?php endif; ?>
                        </div>
                    </details>
                </div>
                <div class="action-area">
                    <?php if ($match['is_joined']): ?>
                        <a href="my-matches.php" class="action-button btn-joined">Joined</a>
                    <?php elseif ($spots_filled >= $total_spots): ?>
                        <button class="action-button btn-full" disabled>Match Full</button>
                    <?php else: ?>
                        <a href="join.php?match_id=<?php echo $match['id']; ?>" class="action-button btn-join">Join Now</a>
                    <?php endif; ?>
                </div>
                <div class="countdown" data-time="<?php echo date('Y-m-d\TH:i:s', strtotime($match['match_time'])); ?>">Loading...</div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
<script>
    function updateCountdowns() {
        document.querySelectorAll('.countdown').forEach(div => {
            const matchTime = new Date(div.getAttribute('data-time')).getTime();
            const now = new Date().getTime();
            const diff = matchTime - now;
            if (diff <= 0) {
                div.textContent = "MATCH HAS STARTED";
            } else {
                const d = Math.floor(diff / (1000 * 60 * 60 * 24));
                const h = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60))).padStart(2, '0');
                const m = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
                const s = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2, '0');
                div.textContent = `STARTS IN- ${d}d: ${h}h: ${m}m: ${s}s`;
            }
        });
    }
    setInterval(updateCountdowns, 1000);
    document.addEventListener('DOMContentLoaded', updateCountdowns);
</script>
</body>
</html>