<?php
require_once 'session_check.php';

$sql = "SELECT 
            t.id, t.title, t.match_time, t.prize_pool, t.category, t.image_url
        FROM tournaments t
        WHERE t.status = 'completed'
        ORDER BY t.match_time DESC";

$result = $conn->query($sql);
$completed_matches = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $completed_matches[] = $row;
    }
}
$conn->close();

$category_map = [
    'br' => 'BR Match',
    'cs' => 'Clash Squad',
    'lone' => 'Lone Wolf',
    'cs2' => 'CS 2 VS 2',
    'ludo' => 'Ludo',
    'free' => 'Free Match'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Match Results</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');
        :root {
            --primary-color: #6c5ce7;
            --background-color: #f0f2f5;
            --card-background: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--background-color);
            margin: 0;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .page-header {
            text-align: center;
            color: var(--text-primary);
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .results-grid {
            display: grid;
            gap: 20px;
        }
        .result-card {
            background: var(--card-background);
            border-radius: 16px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.07);
            overflow: hidden;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .result-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .card-header {
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .card-header img {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            object-fit: cover;
        }
        .header-info {
            flex-grow: 1;
        }
        .header-info h3 {
            margin: 0 0 4px;
            font-size: 18px;
            color: var(--text-primary);
        }
        .header-info span {
            font-size: 14px;
            color: var(--text-secondary);
        }
        
    
        .card-body {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-top: 1px solid #e9ecef;
        }

        .info-item span {
            display: block;
            font-size: 13px;
            color: var(--text-secondary);
            margin-bottom: 2px;
        }
        .info-item strong {
            font-size: 16px;
            font-weight: 600;
            color: var(--text-primary);
        }
        .info-item strong.prize {
            color: var(--primary-color);
        }
        /* NEW STYLE to right-align the category text */
        .info-item.align-right {
            text-align: right;
        }

        .card-footer {
            background-color: #f8f9fa;
        }
        .view-result-btn {
            display: block;
            width: 100%;
            padding: 15px;
            background: var(--primary-color);
            color: white;
            text-align: center;
            text-decoration: none;
            font-weight: 600;
            font-size: 16px;
            transition: background-color 0.2s;
        }
        .view-result-btn:hover {
            background-color: #5a4bd9;
        }
        .no-data { text-align:center; margin-top:50px; color: var(--text-secondary); }
        
        
         .bottom-nav { position: fixed; bottom: 0; left: 0; right: 0; background: white; display: flex; justify-content: space-around; border-top: 1px solid #eee; padding: 8px 0; box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05); }


        .bottom-nav a { text-align: center; text-decoration: none; color: #333; font-size: 12px; font-weight: 500; display: flex; flex-direction: column; align-items: center; }


        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }


        .bottom-nav a.active { color: #2980b9; } 


        @media (max-width: 768px) { .profile-header h2 { font-size: 20px; } .profile-stats div strong { font-size: 16px; } }
        
    </style>
</head>
<body>
    <div class="container">
        <h1 class="page-header">Match Results</h1>
        <div class="results-grid">
            <?php if (empty($completed_matches)): ?>
                <p class="no-data">No completed match results are available yet.</p>
            <?php else: ?>
                <?php foreach ($completed_matches as $match): ?>
                    <div class="result-card">
                        <div class="card-header">
                            <img src="<?php echo htmlspecialchars($match['image_url']); ?>" alt="Game">
                            <div class="header-info">
                                <h3><?php echo htmlspecialchars($match['title']); ?></h3>
                                <span><?php echo date("d F Y, h:i A", strtotime($match['match_time'])); ?></span>
                            </div>
                        </div>
                        
                    
                        <div class="card-body">
                            <div class="info-item">
                                <span>Prize Pool</span>
                                <strong class="prize">Tk <?php echo htmlspecialchars($match['prize_pool']); ?></strong>
                            </div>
                            <div class="info-item align-right">
                                <span>Category</span>
                                <strong>
                                    <?php 
                                    echo htmlspecialchars($category_map[$match['category']] ?? strtoupper($match['category'])); 
                                    ?>
                                </strong>
                            </div>
                        </div>

                        <div class="card-footer">
                            <a href="full-result.php?match_id=<?php echo $match['id']; ?>" class="view-result-btn">View Full Result</a>
                        </div>
                    </div>
                    
                    <div class="bottom-nav">


    <a href="home.php"><img src="icons/play.png"><span>Play</span></a>


    <a href="my-matches.php"><img src="icons/match.png"><span>My Matches</span></a>


    <a href="results.php"><img src="icons/results.png"><span>Results</span></a>


    


    <a href="profile.php" class="active"><img src="icons/profile.png"><span>Profile</span></a>


</div>
                    
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>