<?php
// Set a higher execution time limit for tasks like broadcasting
set_time_limit(180);

// ========================================================================
// --- CONFIGURATION - (PRE-FILLED WITH YOUR DETAILS) ---
// ========================================================================
define('DB_HOST', 'localhost');
define('DB_USER', 'battlekingbd_support_bot_ar');
define('DB_PASS', 'Support444@#');
define('DB_NAME', 'battlekingbd_supportt_bott');

$botToken    = "8002099824:AAHcA2EyTMEm0aN6JKMqMcahABovQafZJrI";
$adminChatId = "7061571573";
$website     = "https://api.telegram.org/bot".$botToken;
$logFile     = 'telegram_bot.log';

// ========================================================================
// --- DATABASE CONNECTION ---
// ========================================================================
$db = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($db->connect_error) {
    logMessage("Database Connection Failed: " . $db->connect_error);
    exit('Database connection error.');
}
$db->set_charset("utf8mb4");

// ========================================================================
// --- HELPER & DATABASE FUNCTIONS ---
// ========================================================================
function logMessage($message) {
    global $logFile;
    @file_put_contents($logFile, date('[Y-m-d H:i:s]') . " " . $message . PHP_EOL, FILE_APPEND);
}

function makeApiCall($url, $params = []) {
    $fullUrl = $url . '?' . http_build_query($params);
    $response = @file_get_contents($fullUrl);
    if ($response === false) {
        $error = error_get_last();
        logMessage("API Call FAILED to $fullUrl. Error: " . ($error['message'] ?? 'Unknown error'));
        return false;
    }
    return json_decode($response, true);
}

function update_user_in_db($chatId, $username, $firstName, $lastName) {
    global $db;
    $stmt = $db->prepare("INSERT INTO telegram_users (chat_id, username, first_name, last_name) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE username = VALUES(username), first_name = VALUES(first_name), last_name = VALUES(last_name), last_interaction = NOW()");
    $stmt->bind_param('isss', $chatId, $username, $firstName, $lastName);
    $stmt->execute();
    $stmt->close();
}

function get_user_details_from_db($chatId) {
    global $db;
    $stmt = $db->prepare("SELECT * FROM telegram_users WHERE chat_id = ?");
    $stmt->bind_param('i', $chatId);
    $stmt->execute();
    $result = $stmt->get_result();
    $details = $result->fetch_assoc();
    $stmt->close();
    return $details;
}

function set_user_state_in_db($chatId, $state) {
    global $db;
    $stmt = $db->prepare("UPDATE telegram_users SET user_state = ? WHERE chat_id = ?");
    $stmt->bind_param('si', $state, $chatId);
    $stmt->execute();
    $stmt->close();
    logMessage("User $chatId state set to: $state in DB.");
}

function get_all_user_ids() {
    global $db;
    $ids = [];
    $result = $db->query("SELECT chat_id FROM telegram_users");
    while ($row = $result->fetch_assoc()) {
        $ids[] = $row['chat_id'];
    }
    return $ids;
}

function get_user_count() {
    global $db;
    $result = $db->query("SELECT COUNT(*) as count FROM telegram_users");
    $row = $result->fetch_assoc();
    return $row['count'] ?? 0;
}

function save_user_email($chatId, $email) {
    global $db;
    $stmt = $db->prepare("UPDATE telegram_users SET website_email = ? WHERE chat_id = ?");
    $stmt->bind_param('si', $email, $chatId);
    $stmt->execute();
    $stmt->close();
}

function save_user_registration_details($chatId, $email, $username) {
    global $db;
    $stmt = $db->prepare("UPDATE telegram_users SET website_email = ?, website_username = ? WHERE chat_id = ?");
    $stmt->bind_param('ssi', $email, $username, $chatId);
    $stmt->execute();
    $stmt->close();
}

// ========================================================================
// --- TELEGRAM API FUNCTIONS ---
// ========================================================================
function sendMessage($chatId, $message, $website, $keyboard = null) {
    $params = ['chat_id' => $chatId, 'parse_mode' => 'HTML', 'text' => $message];
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard);
    return makeApiCall($website.'/sendMessage', $params);
}

function editMessageText($chatId, $messageId, $text, $website, $keyboard = null) {
    $params = ['chat_id' => $chatId, 'message_id' => $messageId, 'parse_mode' => 'HTML', 'text' => $text];
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard);
    makeApiCall($website.'/editMessageText', $params);
}

function answerCallbackQuery($callbackQueryId, $website, $text = null, $showAlert = false) {
    $params = ['callback_query_id' => $callbackQueryId];
    if ($text) $params['text'] = $text;
    if ($showAlert) $params['show_alert'] = 'true';
    makeApiCall($website.'/answerCallbackQuery', $params);
}

// ========================================================================
// --- DYNAMIC KEYBOARD GENERATION ---
// ========================================================================
function generateKeyboardFor($db, $parentId) {
    $stmt = $db->prepare("SELECT button_text, callback_data FROM bot_options WHERE parent_id = ? ORDER BY id ASC");
    $stmt->bind_param('i', $parentId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        return null;
    }

    $keyboard = [];
    while ($row = $result->fetch_assoc()) {
        $keyboard[] = [['text' => $row['button_text'], 'callback_data' => $row['callback_data']]];
    }

    // Add a "Back to Main Menu" button if it's not the main menu
    if ($parentId != 0) {
        $keyboard[] = [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']];
    }
    
    return ['inline_keyboard' => $keyboard];
}

// ========================================================================
// --- LEGACY KEYBOARD DEFINITIONS (FOR BACKWARD COMPATIBILITY) ---
// ========================================================================
function getMainMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'ডিপোজিট সমস্যা', 'callback_data' => 'deposit_main_menu']],[['text' => 'উত্তোলন সমস্যা', 'callback_data' => 'withdrawal_main_menu']],[['text' => 'ওয়েবসাইট সমস্যা', 'callback_data' => 'website_main_menu']],[['text' => 'টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা', 'callback_data' => 'registration_main_menu']],[['text' => 'অ্যাকাউন্ট সম্পর্কিত সমস্যা', 'callback_data' => 'account_main_menu']]]];
}
function getDepositMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'ডিপোজিট সম্পূর্ণ হয়নি', 'callback_data' => 'deposit_not_credited']],[['text' => 'ট্রানজাকশন আইডি জমা দিন', 'callback_data' => 'deposit_submit_tx_id']],[['text' => 'ডিপোজিট প্রুফ দিন (স্ক্রিনশট)', 'callback_data' => 'deposit_submit_proof']],[['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]]];
}
function getWithdrawalMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'উত্তোলন পাচ্ছি না', 'callback_data' => 'withdrawal_not_received']],[['text' => 'উত্তোলন সর্বনিম্ন Amount', 'callback_data' => 'withdrawal_min_amount']],[['text' => 'উত্তোলন প্রসেসিং সময়', 'callback_data' => 'withdrawal_processing_time']],[['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]]];
}
function getWebsiteMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'ওয়েবসাইট খুলছে না', 'callback_data' => 'website_not_opening']],[['text' => 'ক্যাশ ও কুকিজ পরিষ্কার করুন', 'callback_data' => 'website_clear_cache']],[['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]]];
}
function getRegistrationMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'ব্যালেন্স/আইডি সমস্যা', 'callback_data' => 'registration_balance_id']],[['text' => 'টুর্নামেন্ট রুলস দেখুন', 'callback_data' => 'registration_view_rules']],[['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]]];
}
function getAccountMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'পাসওয়ার্ড ভুলে গেছি', 'callback_data' => 'account_forgot_password']],[['text' => 'অ্যাকাউন্ট হ্যাক হয়েছে', 'callback_data' => 'account_hacked']],[['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]]];
}
function getAdminMenuKeyboard() {
    return ['inline_keyboard' => [[['text' => 'Broadcast Message', 'callback_data' => 'admin_broadcast']],[['text' => 'User Stats', 'callback_data' => 'admin_stats']]]];
}

// ========================================================================
// --- MAIN BOT LOGIC ---
// ========================================================================
$update = file_get_contents('php://input');
logMessage("Received update: " . $update);
$update = json_decode($update, TRUE);

// Initialize variables
$chatId = $fromId = $messageId = $messageText = $callbackQueryId = $callbackData = $documentFileId = null;
$isPhoto = false;

// Process incoming update
if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $fromId = $update["message"]["from"]["id"];
    $messageId = $update["message"]["message_id"];
    $firstName = $update["message"]["from"]["first_name"] ?? '';
    $lastName = $update["message"]["from"]["last_name"] ?? '';
    $username = $update["message"]["from"]["username"] ?? '';
    
    update_user_in_db($chatId, $username, $firstName, $lastName);

    if (isset($update["message"]["text"])) {
        $messageText = $update["message"]["text"]; // BUG FIX WAS HERE
    } elseif (isset($update["message"]["photo"])) {
        $isPhoto = true;
        $photoArray = $update["message"]["photo"];
        $documentFileId = end($photoArray)['file_id'];
    } elseif (isset($update["message"]["document"])) {
        $documentFileId = $update["message"]["document"]["file_id"];
    }
} elseif (isset($update["callback_query"])) {
    $chatId = $update["callback_query"]["message"]["chat"]["id"];
    $fromId = $update["callback_query"]["from"]["id"];
    $callbackQueryId = $update["callback_query"]["id"];
    $callbackData = $update["callback_query"]["data"];
    $messageId = $update["callback_query"]["message"]["message_id"];
    answerCallbackQuery($callbackQueryId, $website);
} else {
    exit();
}

// Get user details, including their state
$userDetails = get_user_details_from_db($chatId);
$userState = $userDetails['user_state'] ?? 'main_menu';
logMessage("User $chatId state from DB: $userState");

// --- Process Update Based on Type ---
if ($messageText) {
    // Check for admin state first
    if ($fromId == $adminChatId && $userState == 'awaiting_broadcast_message') {
        sendMessage($chatId, "Broadcasting your message now... Please wait.", $website);
        $allUsers = get_all_user_ids();
        $sentCount = 0;
        foreach ($allUsers as $userId) {
            usleep(100000); // 0.1 second delay to avoid hitting API rate limits
            $result = sendMessage($userId, $messageText, $website);
            if ($result && isset($result['ok']) && $result['ok']) {
                $sentCount++;
            } else {
                logMessage("Broadcast failed for user $userId. Response: " . json_encode($result));
            }
        }
        sendMessage($chatId, "Broadcast finished. Sent to <b>$sentCount / " . count($allUsers) . "</b> users.", $website);
        set_user_state_in_db($chatId, 'main_menu');
    } else {
        // Handle different states for regular users
        switch ($userState) {
            case 'awaiting_email':
                if (filter_var($messageText, FILTER_VALIDATE_EMAIL)) {
                    save_user_email($chatId, $messageText);
                    sendMessage($chatId, "Thank you! Now, please enter the username you used to register on our website.", $website);
                    set_user_state_in_db($chatId, 'awaiting_username');
                } else {
                    sendMessage($chatId, "That doesn't look like a valid email address. Please try again.", $website);
                }
                break;
            case 'awaiting_username':
                $email = $userDetails['website_email'];
                save_user_registration_details($chatId, $email, $messageText);
                sendMessage($chatId, "✅ Registration complete! You can now use the support menu.", $website);
                // Use dynamic keyboard for main menu
                $mainMenuKeyboard = generateKeyboardFor($db, 0);
                sendMessage($chatId, "How can we help you today?", $website, $mainMenuKeyboard);
                set_user_state_in_db($chatId, 'main_menu');
                break;
            case 'awaiting_transaction_id':
                if ($adminChatId) {
                    $adminCaption = "New Transaction ID received:\n\n";
                    $adminCaption .= "👤 <b>User:</b> " . htmlspecialchars($userDetails['website_username'] ?? 'Not set') . "\n";
                    $adminCaption .= "📧 <b>Email:</b> " . htmlspecialchars($userDetails['website_email'] ?? 'Not set') . "\n";
                    $adminCaption .= "🆔 <b>Chat ID:</b> <code>$chatId</code>\n\n";
                    $adminCaption .= "<b>Transaction ID:</b>\n<code>" . htmlspecialchars($messageText) . "</code>";
                    sendMessage($adminChatId, $adminCaption, $website);
                }
                sendMessage($chatId, "Your Transaction ID has been received and sent for verification.", $website);
                $mainMenuKeyboard = generateKeyboardFor($db, 0);
                sendMessage($chatId, "How can we help you today?", $website, $mainMenuKeyboard);
                set_user_state_in_db($chatId, 'main_menu');
                break;
            default: // Handles /start and any other text in 'main_menu' state
                if ($messageText === "/start") {
                    if (empty($userDetails['website_email']) || empty($userDetails['website_username'])) {
                        sendMessage($chatId, "Welcome! To provide the best support, we need to link your Telegram account to your website profile.\n\nPlease enter the email address you used to register on our website.", $website);
                        set_user_state_in_db($chatId, 'awaiting_email');
                    } else {
                        $mainMenuKeyboard = generateKeyboardFor($db, 0);
                        sendMessage($chatId, "Welcome back, " . htmlspecialchars($userDetails['first_name'] ?? 'user') . "! How can we help you today?", $website, $mainMenuKeyboard);
                        set_user_state_in_db($chatId, 'main_menu');
                    }
                } elseif ($messageText === "/admin" && $fromId == $adminChatId) {
                    sendMessage($chatId, "Welcome, Admin! What would you like to do?", $website, getAdminMenuKeyboard());
                } else {
                    $mainMenuKeyboard = generateKeyboardFor($db, 0);
                    sendMessage($chatId, "Sorry, I didn't understand that. Please use one of the menu options.", $website, $mainMenuKeyboard);
                }
                break;
        }
    }
} elseif (($isPhoto || $documentFileId) && $userState == 'awaiting_deposit_screenshot') {
    sendMessage($chatId, "Your proof has been received! We will review it shortly.", $website);
    if ($adminChatId) {
        $caption = "New Deposit Proof received:\n\n";
        $caption .= "👤 <b>User:</b> " . htmlspecialchars($userDetails['website_username'] ?? 'Not set') . "\n";
        $caption .= "📧 <b>Email:</b> " . htmlspecialchars($userDetails['website_email'] ?? 'Not set') . "\n";
        $caption .= "🆔 <b>Chat ID:</b> <code>$chatId</code>";
        
        $params = [
            'chat_id' => $adminChatId,
            'photo' => $documentFileId,
            'parse_mode' => 'HTML',
            'caption' => $caption
        ];
        makeApiCall($website."/sendPhoto", $params);
    }
    sendMessage($chatId, "Our helpline: <code>01711223344</code>", $website);
    $mainMenuKeyboard = generateKeyboardFor($db, 0);
    sendMessage($chatId, "How can we help you today?", $website, $mainMenuKeyboard);
    set_user_state_in_db($chatId, 'main_menu');

} elseif ($callbackData) {
    if ($fromId == $adminChatId) {
        switch ($callbackData) {
            case 'admin_broadcast':
                editMessageText($chatId, $messageId, "Please type the message you want to broadcast to all users.", $website);
                set_user_state_in_db($chatId, 'awaiting_broadcast_message');
                $db->close(); exit();
            case 'admin_stats':
                $count = get_user_count();
                $statsText = "📊 <b>Bot Statistics:</b>\n\nTotal Unique Users: <b>$count</b>";
                editMessageText($chatId, $messageId, $statsText, $website, getAdminMenuKeyboard());
                $db->close(); exit();
        }
    }
    
    // Check if user needs to register first before allowing menu actions
    if (empty($userDetails['website_email']) || empty($userDetails['website_username'])) {
        sendMessage($chatId, "Please complete your registration first by sending /start.", $website);
        $db->close(); exit();
    }
    
    // --- DYNAMIC CALLBACK HANDLING ---
    if ($callbackData == 'back_to_main_menu') {
        $mainMenuKeyboard = generateKeyboardFor($db, 0);
        editMessageText($chatId, $messageId, 'How can we help you today?', $website, $mainMenuKeyboard);
        set_user_state_in_db($chatId, 'main_menu');
    } else {
        // Fetch the option from the database based on callback_data
        $stmt = $db->prepare("SELECT * FROM bot_options WHERE callback_data = ? LIMIT 1");
        $stmt->bind_param('s', $callbackData);
        $stmt->execute();
        $option = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($option) {
            $responseText = $option['response_text'];
            $stateToSet = $option['state_to_set'];
            
            // Generate a keyboard for any sub-options
            $keyboard = generateKeyboardFor($db, $option['id']);

            // Send the response
            editMessageText($chatId, $messageId, $responseText, $website, $keyboard);

            // Set a new state if required
            if (!empty($stateToSet)) {
                set_user_state_in_db($chatId, $stateToSet);
            }
        } else {
            // --- LEGACY CALLBACK HANDLING (FOR BACKWARD COMPATIBILITY) ---
            switch ($callbackData) {
                // Main Menu Navigation
                case 'deposit_main_menu': editMessageText($chatId, $messageId, "ডিপোজিট সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getDepositMenuKeyboard()); break;
                case 'withdrawal_main_menu': editMessageText($chatId, $messageId, "উত্তোলন সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getWithdrawalMenuKeyboard()); break;
                case 'website_main_menu': editMessageText($chatId, $messageId, "ওয়েবসাইট সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getWebsiteMenuKeyboard()); break;
                case 'registration_main_menu': editMessageText($chatId, $messageId, "টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getRegistrationMenuKeyboard()); break;
                case 'account_main_menu': editMessageText($chatId, $messageId, "অ্যাকাউন্ট সম্পর্কিত সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getAccountMenuKeyboard()); break;

                // Deposit Sub-menu
                case 'deposit_not_credited': editMessageText($chatId, $messageId, "ডিপোজিট সমস্যার সমাধান:\n\n• প্রথমে আপনার ট্রানজাকশন আইডি চেক করুন\n• যদি পেমেন্ট সফল হয় কিন্তু ব্যালেন্স না আসে, তাহলে আমাদেরকে ট্রানজাকশন প্রুফ স্ক্রিনশট দিন\n• সাধারণত ১০-১৫ মিনিটের মধ্যে ডিপোজিট রিফ্লেক্ট করে\n• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getDepositMenuKeyboard()); break;
                case 'deposit_submit_tx_id': editMessageText($chatId, $messageId, "অনুগ্রহ করে আপনার ট্রানজাকশন আইডিটি (Transaction ID) টাইপ করে পাঠান।", $website); set_user_state_in_db($chatId, 'awaiting_transaction_id'); break;
                case 'deposit_submit_proof': editMessageText($chatId, $messageId, "আপনার ডিপোজিট সফল হয়েছে এমন একটি স্ক্রিনশট বা ছবি পাঠান।", $website); set_user_state_in_db($chatId, 'awaiting_deposit_screenshot'); break;

                // Withdrawal Sub-menu
                case 'withdrawal_not_received': editMessageText($chatId, $messageId, "উত্তোলন সমস্যায় ভুগলে:\n• আপনার উত্তোলন অনুরোধের স্ট্যাটাস চেক করুন।\n• নিশ্চিত করুন যে আপনার ওয়ালেট ঠিকানা সঠিক আছে।\n• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getWithdrawalMenuKeyboard()); break;
                case 'withdrawal_min_amount': editMessageText($chatId, $messageId, "উত্তোলনের সর্বনিম্ন Amount:\n• উত্তোলনের সর্বনিম্ন Amount ১০০ টাকা\n• উত্তোলন করতে সর্বনিম্ন ৫০ ডায়মন্ড প্রয়োজন", $website, getWithdrawalMenuKeyboard()); break;
                case 'withdrawal_processing_time': editMessageText($chatId, $messageId, "উত্তোলন প্রসেসিং সময়:\n• উত্তোলন রিকোয়েস্ট করার ২৪ ঘন্টার মধ্যে প্রসেস করা হয়। ছুটির দিনে কিছুটা সময় বেশি লাগতে পারে।", $website, getWithdrawalMenuKeyboard()); break;

                // Website Sub-menu
                case 'website_not_opening': editMessageText($chatId, $messageId, "যদি ওয়েবসাইট না খোলে:\n• প্রথমে আপনার ইন্টারনেট কানেকশন চেক করুন।\n• অন্য ডিভাইস বা নেটওয়ার্ক থেকে চেষ্টা করুন।\n• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getWebsiteMenuKeyboard()); break;
                case 'website_clear_cache': editMessageText($chatId, $messageId, "ব্রাউজারের ক্যাশ এবং কুকিজ পরিষ্কার করুন:\n• আপনার ব্রাউজারের সেটিংস এ যান।\n• 'Privacy and security' বা 'History' অপশনে 'Clear browsing data' খুঁজুন।\n• ক্যাশড ইমেজ এবং ফাইল, কুকিজ এবং সাইট ডেটা নির্বাচন করে পরিষ্কার করুন।", $website, getWebsiteMenuKeyboard()); break;

                // Registration Sub-menu
                case 'registration_balance_id': editMessageText($chatId, $messageId, "টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা:\n\n• আপনার অ্যাকাউন্টে পর্যাপ্ত ব্যালেন্স আছে কিনা নিশ্চিত করুন।\n• রেজিস্ট্রেশনের সময় সঠিক ফ্রি ফায়ার আইডি (Player ID) দিয়েছেন কিনা চেক করুন।\n• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getRegistrationMenuKeyboard()); break;
                case 'registration_view_rules': editMessageText($chatId, $messageId, "টুর্নামেন্ট রুলস দেখতে এই লিঙ্কে ক্লিক করুন: <a href='https://battlekingbd.site/all_match_rules.php'>এখানে ক্লিক করুন</a>", $website, getRegistrationMenuKeyboard()); break;

                // Account Sub-menu
                case 'account_forgot_password': editMessageText($chatId, $messageId, "পাসওয়ার্ড ভুলে গেলে:\n\n• ওয়েবসাইটে 'Forgot Password' অপশনটি ব্যবহার করুন।\n• আপনার ইমেল বা ফোন নম্বরে একটি রিসেট লিঙ্ক পাঠানো হবে।\n• এরপরও সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getAccountMenuKeyboard()); break;
                case 'account_hacked': editMessageText($chatId, $messageId, "আপনার অ্যাকাউন্ট হ্যাক হলে:\n\n• অবিলম্বে আমাদের হেল্পলাইন <code>01711223344</code> নম্বরে যোগাযোগ করুন।\n• আপনার ইউজার আইডি এবং সর্বশেষ অ্যাক্সেসের তথ্য প্রস্তুত রাখুন।", $website, getAccountMenuKeyboard()); break;
            }
        }
    }
}
// Close the database connection at the end of the script
$db->close();
?>