<?php


session_start(); 
require_once 'db_connect.php';


$sql = "SELECT username, balance FROM users ORDER BY balance DESC LIMIT 10";

$result = $conn->query($sql);
$top_players = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $top_players[] = $row;
    }
}
$conn->close();
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>Hunter BD71 - Top Players</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: linear-gradient(135deg, #f0f2f5, #e0eafc); padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 20px; border-radius: 20px; box-shadow: 0 6px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #2c3e50; margin-bottom: 25px; font-size: 28px; text-transform: uppercase; letter-spacing: 1px; }
        table { width: 100%; border-collapse: collapse; border-radius: 12px; overflow: hidden; }
        th, td { padding: 15px; text-align: center; }
        th { background: #3498db; color: white; font-weight: bold; font-size: 16px; }
        tr:nth-child(even) { background: #f9f9f9; }
        tr:nth-child(odd) { background: #eef4ff; }
        td { color: #333; font-size: 15px; }
        .rank { font-weight: bold; color: #f39c12; }
        @media (max-width: 768px) { body { padding: 10px; } .container { padding: 15px; } th, td { font-size: 14px; padding: 10px; } }
    </style>
</head>
<body>

    <div class="container">
        <h2>Top 10 Players</h2>
        <table>
            <thead> 
                <tr>
                    <th>Rank</th>
                    <th>Player Name</th>
                    <th>Balance (BDT)</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($top_players)): ?>
                    <tr>
                        <td colspan="3">No players found.</td>
                    </tr>
                <?php else: ?>
                    <?php 
                    
                    $rank = 1; 
                    foreach ($top_players as $player): 
                    ?>
                        <tr>
                            <td class="rank"><?php echo $rank; ?></td>
                            <td><?php echo htmlspecialchars($player['username']); ?></td>
                            
                            <td>৳<?php echo htmlspecialchars(number_format($player['balance'], 2)); ?></td>
                        </tr>
                    <?php 
                    
                    $rank++; 
                    endforeach; 
                    ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</body>
</html>