<?php


session_start();
require_once 'db_connect.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];


$sql = "SELECT 
            u.username,
            u.mobile_number,
            u.balance,
            (SELECT COALESCE(SUM(amount), 0) FROM transactions WHERE user_id = u.id AND type = 'deposit' AND status = 'completed') as total_deposit,
            (SELECT COALESCE(SUM(ABS(amount)), 0) FROM transactions WHERE user_id = u.id AND type = 'withdrawal' AND status = 'completed') as total_withdraw
        FROM users u
        WHERE u.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$wallet_data = $result->fetch_assoc();

if (!$wallet_data) {
    die("Error: Could not retrieve wallet data.");
}


$sql_settings = "SELECT setting_key, setting_value FROM settings 
                 WHERE setting_key IN ('video_add_money', 'video_room_id', 'video_join_match')";
$settings_result = $conn->query($sql_settings);
$video_links = [];
while ($row = $settings_result->fetch_assoc()) {
    $video_links[$row['setting_key']] = $row['setting_value'];
}


$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Wallet</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        :root {
            --primary-gradient: linear-gradient(135deg, #6a11cb, #2575fc);
            --background-color: #f4f7f9;
            --card-background: #ffffff;
            --text-primary: #1d2129;
            --text-secondary: #65676b;
            --green-btn: #27ae60;
            --blue-btn: #2980b9;
            --purple-btn: #8e44ad;
            --dark-btn: #2c3e50;
            --red-btn: #e74c3c;
        }
        body {
            font-family: 'Roboto', sans-serif;
            background: var(--background-color);
            margin: 0;
            padding: 0;
        }
        .container {
            padding: 20px;
            max-width: 600px;
            margin: auto;
        }
        .balance-box {
            background: var(--primary-gradient);
            color: white;
            padding: 30px 20px;
            text-align: center;
            border-radius: 20px;
            margin-bottom: 25px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        .balance-box h2 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
            letter-spacing: 1px;
        }
        .balance-box small {
            display: block;
            margin-top: 8px;
            font-size: 14px;
            opacity: 0.8;
        }
        .card {
            background: var(--card-background);
            border-radius: 16px;
            margin-bottom: 20px;
            padding: 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            border: 1px solid #e9ecef;
        }
        .card h3 {
            margin: 0 0 10px;
            color: var(--text-primary);
            font-size: 16px;
            font-weight: 500;
        }
        .amount {
            font-size: 26px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 15px;
        }
        .btn {
            display: inline-block;
            padding: 10px 22px;
            border-radius: 8px;
            color: white;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            border: none;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
        }
        .btn-green { background: var(--green-btn); }
        .btn-blue { background: var(--blue-btn); }
        .btn-purple { background: var(--purple-btn); }
        .btn-dark { background: var(--dark-btn); }

        .video-box {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #f8f9fa;
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 10px;
            border: 1px solid #e9ecef;
        }
        .video-box:last-child {
            margin-bottom: 0;
        }
        .video-box span {
            font-size: 14px;
            color: var(--text-secondary);
        }
        .video-box a {
            background: var(--red-btn);
            padding: 6px 14px;
            border-radius: 6px;
            color: white;
            text-decoration: none;
            font-size: 13px;
            font-weight: 500;
            transition: background 0.2s;
        }
        .video-box a:hover {
            background: #c0392b;
        }

 .bottom-nav a { text-align: center; text-decoration: none; color: #333; font-size: 12px; font-weight: 500; display: flex; flex-direction: column; align-items: center; }


        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }


        .bottom-nav a.active { color: #2980b9; } 


        @media (max-width: 768px) { .profile-header h2 { font-size: 20px; } .profile-stats div strong { font-size: 16px; } }


    </style>
</head>
<body>

<div class="container">
    <div class="balance-box">
        
        <h2>BDT <?php echo htmlspecialchars(number_format($wallet_data['balance'], 2)); ?></h2>
        
        <small>Total Cash Balance | <?php echo htmlspecialchars($wallet_data['username']); ?> (<?php echo htmlspecialchars($wallet_data['mobile_number']); ?>)</small>
    </div>

    <div class="card">
        <h3>TOTAL WITHDRAWN</h3>
        
        <div class="amount">BDT <?php echo htmlspecialchars(number_format($wallet_data['total_withdraw'], 2)); ?></div>
        <a href="withdraw.php" class="btn btn-green">Withdraw Now</a>
    </div>

    <div class="card">
        <h3>TOTAL DEPOSITED</h3>
        
        <div class="amount">BDT <?php echo htmlspecialchars(number_format($wallet_data['total_deposit'], 2)); ?></div>
        <a href="add-money.php" class="btn btn-blue">Add Money</a>
    </div>

    <div class="card">
        <h3>REFER & EARN</h3>
        <a href="refer.php" class="btn btn-purple">Refer & Earn</a>
    </div>

    <div class="card">
        <h3>VIEW TRANSACTION HISTORY</h3>
        <a href="transaction-history.php" class="btn btn-dark">View Transactions</a>
    </div>

       
    <div class="card">
        <h3>Video Help</h3>
        
        
        <?php if (!empty($video_links['video_add_money'])): ?>
        <div class="video-box">
            <span>How to Add Money</span>
            <a href="<?php echo htmlspecialchars($video_links['video_add_money']); ?>" target="_blank">Watch</a>
        </div>
        <?php endif; ?>

        
        <?php if (!empty($video_links['video_room_id'])): ?>
        <div class="video-box">
            <span>How to Collect Room ID</span>
            <a href="<?php echo htmlspecialchars($video_links['video_room_id']); ?>" target="_blank">Watch</a>
        </div>
        <?php endif; ?>

        
        <?php if (!empty($video_links['video_join_match'])): ?>
        <div class="video-box">
            <span>How to Join Match</span>
            <a href="<?php echo htmlspecialchars($video_links['video_join_match']); ?>" target="_blank">Watch</a>
        </div>
        <?php endif; ?>

    </div>
</div>

</body>
</html>